/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.support.DefaultSupportAsyncClient;
import software.amazon.awssdk.services.support.DefaultSupportBaseClientBuilder;
import software.amazon.awssdk.services.support.SupportAsyncClient;
import software.amazon.awssdk.services.support.SupportAsyncClientBuilder;
import software.amazon.awssdk.services.support.SupportServiceClientConfiguration;
import software.amazon.awssdk.services.support.endpoints.SupportEndpointProvider;

@SdkInternalApi
final class DefaultSupportAsyncClientBuilder
extends DefaultSupportBaseClientBuilder<SupportAsyncClientBuilder, SupportAsyncClient>
implements SupportAsyncClientBuilder {
    DefaultSupportAsyncClientBuilder() {
    }

    @Override
    public DefaultSupportAsyncClientBuilder endpointProvider(SupportEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SupportAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSupportAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SupportServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSupportAsyncClient client = new DefaultSupportAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SupportServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SupportServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

