/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.internal;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.token.TokenTransformer;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcToken;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SsoOidcTokenTransformer
implements TokenTransformer<SsoOidcToken, CreateTokenResponse> {
    private final SsoOidcToken baseToken;

    private SsoOidcTokenTransformer(SsoOidcToken baseToken) {
        Validate.notNull((Object)baseToken.startUrl(), (String)"startUrl is null ", (Object[])new Object[0]);
        Validate.notNull((Object)baseToken.clientId(), (String)"clientId is null ", (Object[])new Object[0]);
        Validate.notNull((Object)baseToken.clientSecret(), (String)"clientSecret is null ", (Object[])new Object[0]);
        this.baseToken = baseToken;
    }

    public static SsoOidcTokenTransformer create(SsoOidcToken baseToken) {
        Validate.paramNotNull((Object)baseToken, (String)"baseToken");
        return new SsoOidcTokenTransformer(baseToken);
    }

    public SsoOidcToken transform(CreateTokenResponse awsResponse) {
        Validate.paramNotNull((Object)awsResponse.accessToken(), (String)"accessToken");
        Validate.paramNotNull((Object)awsResponse.expiresIn(), (String)"expiresIn");
        return SsoOidcToken.builder().accessToken(awsResponse.accessToken()).refreshToken(awsResponse.refreshToken()).expiresAt(awsResponse.expiresIn() != null ? Instant.now().plusSeconds(awsResponse.expiresIn().intValue()) : null).startUrl(this.baseToken.startUrl()).registrationExpiresAt(this.baseToken.registrationExpiresAt()).region(this.baseToken.region()).clientSecret(this.baseToken.clientSecret()).clientId(this.baseToken.clientId()).providerName("SsoOidcTokenProvider").build();
    }
}

