/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;

public class ListAccountAssignmentCreationStatusPublisher
implements SdkPublisher<ListAccountAssignmentCreationStatusResponse> {
    private final SsoAdminAsyncClient client;
    private final ListAccountAssignmentCreationStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountAssignmentCreationStatusPublisher(SsoAdminAsyncClient client, ListAccountAssignmentCreationStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountAssignmentCreationStatusPublisher(SsoAdminAsyncClient client, ListAccountAssignmentCreationStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountAssignmentCreationStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountAssignmentCreationStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountAssignmentOperationStatusMetadata> accountAssignmentsCreationStatus() {
        Function<ListAccountAssignmentCreationStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignmentsCreationStatus() != null) {
                return response.accountAssignmentsCreationStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountAssignmentCreationStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountAssignmentCreationStatusResponseFetcher
    implements AsyncPageFetcher<ListAccountAssignmentCreationStatusResponse> {
        private ListAccountAssignmentCreationStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssignmentCreationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountAssignmentCreationStatusResponse> nextPage(ListAccountAssignmentCreationStatusResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentCreationStatusPublisher.this.client.listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusPublisher.this.firstRequest);
            }
            return ListAccountAssignmentCreationStatusPublisher.this.client.listAccountAssignmentCreationStatus((ListAccountAssignmentCreationStatusRequest)((Object)ListAccountAssignmentCreationStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

