/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssoadmin.DefaultSsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.DefaultSsoAdminBaseClientBuilder;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClientBuilder;
import software.amazon.awssdk.services.ssoadmin.SsoAdminServiceClientConfiguration;
import software.amazon.awssdk.services.ssoadmin.endpoints.SsoAdminEndpointProvider;

@SdkInternalApi
final class DefaultSsoAdminAsyncClientBuilder
extends DefaultSsoAdminBaseClientBuilder<SsoAdminAsyncClientBuilder, SsoAdminAsyncClient>
implements SsoAdminAsyncClientBuilder {
    DefaultSsoAdminAsyncClientBuilder() {
    }

    @Override
    public DefaultSsoAdminAsyncClientBuilder endpointProvider(SsoAdminEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsoAdminAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSsoAdminAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SsoAdminServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsoAdminAsyncClient client = new DefaultSsoAdminAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsoAdminServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsoAdminServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

