/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Host implements SdkPojo, Serializable, ToCopyableBuilder<Host.Builder, Host> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostName").getter(getter(Host::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()).build();

    private static final SdkField<String> HOST_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HostIp")
            .getter(getter(Host::hostIp)).setter(setter(Builder::hostIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIp").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceId").getter(getter(Host::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(Host::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> HOST_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostRole").getter(getter(Host::hostRoleAsString)).setter(setter(Builder::hostRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRole").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OsVersion").getter(getter(Host::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD,
            HOST_IP_FIELD, EC2_INSTANCE_ID_FIELD, INSTANCE_ID_FIELD, HOST_ROLE_FIELD, OS_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostName;

    private final String hostIp;

    private final String ec2InstanceId;

    private final String instanceId;

    private final String hostRole;

    private final String osVersion;

    private Host(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hostIp = builder.hostIp;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.instanceId = builder.instanceId;
        this.hostRole = builder.hostRole;
        this.osVersion = builder.osVersion;
    }

    /**
     * <p>
     * The name of the Dedicated Host.
     * </p>
     * 
     * @return The name of the Dedicated Host.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * The IP address of the Dedicated Host.
     * </p>
     * 
     * @return The IP address of the Dedicated Host.
     */
    public final String hostIp() {
        return hostIp;
    }

    /**
     * <p>
     * The ID of Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of Amazon EC2 instance.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The instance ID of the instance on the Dedicated Host.
     * </p>
     * 
     * @return The instance ID of the instance on the Dedicated Host.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The role of the Dedicated Host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRole} will
     * return {@link HostRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRoleAsString}.
     * </p>
     * 
     * @return The role of the Dedicated Host.
     * @see HostRole
     */
    public final HostRole hostRole() {
        return HostRole.fromValue(hostRole);
    }

    /**
     * <p>
     * The role of the Dedicated Host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRole} will
     * return {@link HostRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRoleAsString}.
     * </p>
     * 
     * @return The role of the Dedicated Host.
     * @see HostRole
     */
    public final String hostRoleAsString() {
        return hostRole;
    }

    /**
     * <p>
     * The version of the operating system.
     * </p>
     * 
     * @return The version of the operating system.
     */
    public final String osVersion() {
        return osVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(hostIp());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hostRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(hostIp(), other.hostIp())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(hostRoleAsString(), other.hostRoleAsString()) && Objects.equals(osVersion(), other.osVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Host").add("HostName", hostName()).add("HostIp", hostIp()).add("EC2InstanceId", ec2InstanceId())
                .add("InstanceId", instanceId()).add("HostRole", hostRoleAsString()).add("OsVersion", osVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "HostIp":
            return Optional.ofNullable(clazz.cast(hostIp()));
        case "EC2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "HostRole":
            return Optional.ofNullable(clazz.cast(hostRoleAsString()));
        case "OsVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * The name of the Dedicated Host.
         * </p>
         * 
         * @param hostName
         *        The name of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * The IP address of the Dedicated Host.
         * </p>
         * 
         * @param hostIp
         *        The IP address of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIp(String hostIp);

        /**
         * <p>
         * The ID of Amazon EC2 instance.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The instance ID of the instance on the Dedicated Host.
         * </p>
         * 
         * @param instanceId
         *        The instance ID of the instance on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The role of the Dedicated Host.
         * </p>
         * 
         * @param hostRole
         *        The role of the Dedicated Host.
         * @see HostRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRole
         */
        Builder hostRole(String hostRole);

        /**
         * <p>
         * The role of the Dedicated Host.
         * </p>
         * 
         * @param hostRole
         *        The role of the Dedicated Host.
         * @see HostRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRole
         */
        Builder hostRole(HostRole hostRole);

        /**
         * <p>
         * The version of the operating system.
         * </p>
         * 
         * @param osVersion
         *        The version of the operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String hostIp;

        private String ec2InstanceId;

        private String instanceId;

        private String hostRole;

        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            hostName(model.hostName);
            hostIp(model.hostIp);
            ec2InstanceId(model.ec2InstanceId);
            instanceId(model.instanceId);
            hostRole(model.hostRole);
            osVersion(model.osVersion);
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHostIp() {
            return hostIp;
        }

        public final void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        @Override
        public final Builder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHostRole() {
            return hostRole;
        }

        public final void setHostRole(String hostRole) {
            this.hostRole = hostRole;
        }

        @Override
        public final Builder hostRole(String hostRole) {
            this.hostRole = hostRole;
            return this;
        }

        @Override
        public final Builder hostRole(HostRole hostRole) {
            this.hostRole(hostRole == null ? null : hostRole.toString());
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public Host build() {
            return new Host(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
