/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResponsePlanRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<UpdateResponsePlanRequest.Builder, UpdateResponsePlanRequest> {
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(UpdateResponsePlanRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateResponsePlanRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.<ChatChannel> builder(MarshallingType.SDK_POJO)
            .memberName("chatChannel").getter(getter(UpdateResponsePlanRequest::chatChannel))
            .setter(setter(Builder::chatChannel)).constructor(ChatChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateResponsePlanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateResponsePlanRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<String>> ENGAGEMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("engagements")
            .getter(getter(UpdateResponsePlanRequest::engagements))
            .setter(setter(Builder::engagements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INCIDENT_TEMPLATE_DEDUPE_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("incidentTemplateDedupeString")
            .getter(getter(UpdateResponsePlanRequest::incidentTemplateDedupeString))
            .setter(setter(Builder::incidentTemplateDedupeString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateDedupeString")
                    .build()).build();

    private static final SdkField<Integer> INCIDENT_TEMPLATE_IMPACT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("incidentTemplateImpact").getter(getter(UpdateResponsePlanRequest::incidentTemplateImpact))
            .setter(setter(Builder::incidentTemplateImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateImpact").build())
            .build();

    private static final SdkField<List<NotificationTargetItem>> INCIDENT_TEMPLATE_NOTIFICATION_TARGETS_FIELD = SdkField
            .<List<NotificationTargetItem>> builder(MarshallingType.LIST)
            .memberName("incidentTemplateNotificationTargets")
            .getter(getter(UpdateResponsePlanRequest::incidentTemplateNotificationTargets))
            .setter(setter(Builder::incidentTemplateNotificationTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("incidentTemplateNotificationTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationTargetItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationTargetItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INCIDENT_TEMPLATE_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentTemplateSummary").getter(getter(UpdateResponsePlanRequest::incidentTemplateSummary))
            .setter(setter(Builder::incidentTemplateSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateSummary").build())
            .build();

    private static final SdkField<Map<String, String>> INCIDENT_TEMPLATE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("incidentTemplateTags")
            .getter(getter(UpdateResponsePlanRequest::incidentTemplateTags))
            .setter(setter(Builder::incidentTemplateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INCIDENT_TEMPLATE_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentTemplateTitle").getter(getter(UpdateResponsePlanRequest::incidentTemplateTitle))
            .setter(setter(Builder::incidentTemplateTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplateTitle").build())
            .build();

    private static final SdkField<List<Integration>> INTEGRATIONS_FIELD = SdkField
            .<List<Integration>> builder(MarshallingType.LIST)
            .memberName("integrations")
            .getter(getter(UpdateResponsePlanRequest::integrations))
            .setter(setter(Builder::integrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Integration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, ARN_FIELD,
            CHAT_CHANNEL_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, ENGAGEMENTS_FIELD, INCIDENT_TEMPLATE_DEDUPE_STRING_FIELD,
            INCIDENT_TEMPLATE_IMPACT_FIELD, INCIDENT_TEMPLATE_NOTIFICATION_TARGETS_FIELD, INCIDENT_TEMPLATE_SUMMARY_FIELD,
            INCIDENT_TEMPLATE_TAGS_FIELD, INCIDENT_TEMPLATE_TITLE_FIELD, INTEGRATIONS_FIELD));

    private final List<Action> actions;

    private final String arn;

    private final ChatChannel chatChannel;

    private final String clientToken;

    private final String displayName;

    private final List<String> engagements;

    private final String incidentTemplateDedupeString;

    private final Integer incidentTemplateImpact;

    private final List<NotificationTargetItem> incidentTemplateNotificationTargets;

    private final String incidentTemplateSummary;

    private final Map<String, String> incidentTemplateTags;

    private final String incidentTemplateTitle;

    private final List<Integration> integrations;

    private UpdateResponsePlanRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.arn = builder.arn;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.engagements = builder.engagements;
        this.incidentTemplateDedupeString = builder.incidentTemplateDedupeString;
        this.incidentTemplateImpact = builder.incidentTemplateImpact;
        this.incidentTemplateNotificationTargets = builder.incidentTemplateNotificationTargets;
        this.incidentTemplateSummary = builder.incidentTemplateSummary;
        this.incidentTemplateTags = builder.incidentTemplateTags;
        this.incidentTemplateTitle = builder.incidentTemplateTitle;
        this.integrations = builder.integrations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that this response plan takes at the beginning of an incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions that this response plan takes at the beginning of an incident.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the response plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the response plan.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Chatbot chat channel used for collaboration during an incident.
     * </p>
     * <p>
     * Use the empty structure to remove the chat channel from the response plan.
     * </p>
     * 
     * @return The Chatbot chat channel used for collaboration during an incident.</p>
     *         <p>
     *         Use the empty structure to remove the chat channel from the response plan.
     */
    public final ChatChannel chatChannel() {
        return chatChannel;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The long format name of the response plan. The display name can't contain spaces.
     * </p>
     * 
     * @return The long format name of the response plan. The display name can't contain spaces.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Engagements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagements() {
        return engagements != null && !(engagements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
     * incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagements} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
     *         during an incident.
     */
    public final List<String> engagements() {
        return engagements;
    }

    /**
     * <p>
     * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the
     * same account.
     * </p>
     * 
     * @return The string Incident Manager uses to prevent duplicate incidents from being created by the same incident
     *         in the same account.
     */
    public final String incidentTemplateDedupeString() {
        return incidentTemplateDedupeString;
    }

    /**
     * <p>
     * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
     * </p>
     * <p class="title">
     * <b>Supported impact codes</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> - Critical
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>2</code> - High
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3</code> - Medium
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>4</code> - Low
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>5</code> - No Impact
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the impact to the customers. Providing an impact overwrites the impact provided by a response
     *         plan.</p>
     *         <p class="title">
     *         <b>Supported impact codes</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> - Critical
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>2</code> - High
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3</code> - Medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>4</code> - Low
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>5</code> - No Impact
     *         </p>
     *         </li>
     */
    public final Integer incidentTemplateImpact() {
        return incidentTemplateImpact;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncidentTemplateNotificationTargets
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasIncidentTemplateNotificationTargets() {
        return incidentTemplateNotificationTargets != null
                && !(incidentTemplateNotificationTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SNS targets that are notified when updates are made to an incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidentTemplateNotificationTargets}
     * method.
     * </p>
     * 
     * @return The Amazon SNS targets that are notified when updates are made to an incident.
     */
    public final List<NotificationTargetItem> incidentTemplateNotificationTargets() {
        return incidentTemplateNotificationTargets;
    }

    /**
     * <p>
     * A brief summary of the incident. This typically contains what has happened, what's currently happening, and next
     * steps.
     * </p>
     * 
     * @return A brief summary of the incident. This typically contains what has happened, what's currently happening,
     *         and next steps.
     */
    public final String incidentTemplateSummary() {
        return incidentTemplateSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncidentTemplateTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncidentTemplateTags() {
        return incidentTemplateTags != null && !(incidentTemplateTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to assign to the template. When the <code>StartIncident</code> API action is called, Incident Manager
     * assigns the tags specified in the template to the incident. To call this action, you must also have permission to
     * call the <code>TagResource</code> API action for the incident record resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidentTemplateTags} method.
     * </p>
     * 
     * @return Tags to assign to the template. When the <code>StartIncident</code> API action is called, Incident
     *         Manager assigns the tags specified in the template to the incident. To call this action, you must also
     *         have permission to call the <code>TagResource</code> API action for the incident record resource.
     */
    public final Map<String, String> incidentTemplateTags() {
        return incidentTemplateTags;
    }

    /**
     * <p>
     * The short format name of the incident. The title can't contain spaces.
     * </p>
     * 
     * @return The short format name of the incident. The title can't contain spaces.
     */
    public final String incidentTemplateTitle() {
        return incidentTemplateTitle;
    }

    /**
     * For responses, this returns true if the service returned a value for the Integrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrations() {
        return integrations != null && !(integrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about third-party services integrated into the response plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrations} method.
     * </p>
     * 
     * @return Information about third-party services integrated into the response plan.
     */
    public final List<Integration> integrations() {
        return integrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagements() ? engagements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentTemplateDedupeString());
        hashCode = 31 * hashCode + Objects.hashCode(incidentTemplateImpact());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIncidentTemplateNotificationTargets() ? incidentTemplateNotificationTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentTemplateSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncidentTemplateTags() ? incidentTemplateTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentTemplateTitle());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrations() ? integrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponsePlanRequest)) {
            return false;
        }
        UpdateResponsePlanRequest other = (UpdateResponsePlanRequest) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(arn(), other.arn()) && Objects.equals(chatChannel(), other.chatChannel())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(displayName(), other.displayName())
                && hasEngagements() == other.hasEngagements() && Objects.equals(engagements(), other.engagements())
                && Objects.equals(incidentTemplateDedupeString(), other.incidentTemplateDedupeString())
                && Objects.equals(incidentTemplateImpact(), other.incidentTemplateImpact())
                && hasIncidentTemplateNotificationTargets() == other.hasIncidentTemplateNotificationTargets()
                && Objects.equals(incidentTemplateNotificationTargets(), other.incidentTemplateNotificationTargets())
                && Objects.equals(incidentTemplateSummary(), other.incidentTemplateSummary())
                && hasIncidentTemplateTags() == other.hasIncidentTemplateTags()
                && Objects.equals(incidentTemplateTags(), other.incidentTemplateTags())
                && Objects.equals(incidentTemplateTitle(), other.incidentTemplateTitle())
                && hasIntegrations() == other.hasIntegrations() && Objects.equals(integrations(), other.integrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateResponsePlanRequest")
                .add("Actions", hasActions() ? actions() : null)
                .add("Arn", arn())
                .add("ChatChannel", chatChannel())
                .add("ClientToken", clientToken())
                .add("DisplayName", displayName())
                .add("Engagements", hasEngagements() ? engagements() : null)
                .add("IncidentTemplateDedupeString", incidentTemplateDedupeString())
                .add("IncidentTemplateImpact", incidentTemplateImpact())
                .add("IncidentTemplateNotificationTargets",
                        hasIncidentTemplateNotificationTargets() ? incidentTemplateNotificationTargets() : null)
                .add("IncidentTemplateSummary", incidentTemplateSummary())
                .add("IncidentTemplateTags", hasIncidentTemplateTags() ? incidentTemplateTags() : null)
                .add("IncidentTemplateTitle", incidentTemplateTitle())
                .add("Integrations", hasIntegrations() ? integrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "chatChannel":
            return Optional.ofNullable(clazz.cast(chatChannel()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "engagements":
            return Optional.ofNullable(clazz.cast(engagements()));
        case "incidentTemplateDedupeString":
            return Optional.ofNullable(clazz.cast(incidentTemplateDedupeString()));
        case "incidentTemplateImpact":
            return Optional.ofNullable(clazz.cast(incidentTemplateImpact()));
        case "incidentTemplateNotificationTargets":
            return Optional.ofNullable(clazz.cast(incidentTemplateNotificationTargets()));
        case "incidentTemplateSummary":
            return Optional.ofNullable(clazz.cast(incidentTemplateSummary()));
        case "incidentTemplateTags":
            return Optional.ofNullable(clazz.cast(incidentTemplateTags()));
        case "incidentTemplateTitle":
            return Optional.ofNullable(clazz.cast(incidentTemplateTitle()));
        case "integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResponsePlanRequest, T> g) {
        return obj -> g.apply((UpdateResponsePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResponsePlanRequest> {
        /**
         * <p>
         * The actions that this response plan takes at the beginning of an incident.
         * </p>
         * 
         * @param actions
         *        The actions that this response plan takes at the beginning of an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions that this response plan takes at the beginning of an incident.
         * </p>
         * 
         * @param actions
         *        The actions that this response plan takes at the beginning of an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions that this response plan takes at the beginning of an incident.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmincidents.model.Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the response plan.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Chatbot chat channel used for collaboration during an incident.
         * </p>
         * <p>
         * Use the empty structure to remove the chat channel from the response plan.
         * </p>
         * 
         * @param chatChannel
         *        The Chatbot chat channel used for collaboration during an incident.</p>
         *        <p>
         *        Use the empty structure to remove the chat channel from the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatChannel(ChatChannel chatChannel);

        /**
         * <p>
         * The Chatbot chat channel used for collaboration during an incident.
         * </p>
         * <p>
         * Use the empty structure to remove the chat channel from the response plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatChannel.Builder} avoiding the need to
         * create one manually via {@link ChatChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatChannel.Builder#build()} is called immediately and its result
         * is passed to {@link #chatChannel(ChatChannel)}.
         * 
         * @param chatChannel
         *        a consumer that will call methods on {@link ChatChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatChannel(ChatChannel)
         */
        default Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return chatChannel(ChatChannel.builder().applyMutation(chatChannel).build());
        }

        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The long format name of the response plan. The display name can't contain spaces.
         * </p>
         * 
         * @param displayName
         *        The long format name of the response plan. The display name can't contain spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
         * incident.
         * </p>
         * 
         * @param engagements
         *        The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
         *        during an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagements(Collection<String> engagements);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
         * incident.
         * </p>
         * 
         * @param engagements
         *        The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
         *        during an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagements(String... engagements);

        /**
         * <p>
         * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in
         * the same account.
         * </p>
         * 
         * @param incidentTemplateDedupeString
         *        The string Incident Manager uses to prevent duplicate incidents from being created by the same
         *        incident in the same account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateDedupeString(String incidentTemplateDedupeString);

        /**
         * <p>
         * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
         * </p>
         * <p class="title">
         * <b>Supported impact codes</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> - Critical
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>2</code> - High
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3</code> - Medium
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>4</code> - Low
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>5</code> - No Impact
         * </p>
         * </li>
         * </ul>
         * 
         * @param incidentTemplateImpact
         *        Defines the impact to the customers. Providing an impact overwrites the impact provided by a response
         *        plan.</p>
         *        <p class="title">
         *        <b>Supported impact codes</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> - Critical
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>2</code> - High
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3</code> - Medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>4</code> - Low
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>5</code> - No Impact
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateImpact(Integer incidentTemplateImpact);

        /**
         * <p>
         * The Amazon SNS targets that are notified when updates are made to an incident.
         * </p>
         * 
         * @param incidentTemplateNotificationTargets
         *        The Amazon SNS targets that are notified when updates are made to an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateNotificationTargets(Collection<NotificationTargetItem> incidentTemplateNotificationTargets);

        /**
         * <p>
         * The Amazon SNS targets that are notified when updates are made to an incident.
         * </p>
         * 
         * @param incidentTemplateNotificationTargets
         *        The Amazon SNS targets that are notified when updates are made to an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateNotificationTargets(NotificationTargetItem... incidentTemplateNotificationTargets);

        /**
         * <p>
         * The Amazon SNS targets that are notified when updates are made to an incident.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #incidentTemplateNotificationTargets(List<NotificationTargetItem>)}.
         * 
         * @param incidentTemplateNotificationTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.NotificationTargetItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentTemplateNotificationTargets(java.util.Collection<NotificationTargetItem>)
         */
        Builder incidentTemplateNotificationTargets(
                Consumer<NotificationTargetItem.Builder>... incidentTemplateNotificationTargets);

        /**
         * <p>
         * A brief summary of the incident. This typically contains what has happened, what's currently happening, and
         * next steps.
         * </p>
         * 
         * @param incidentTemplateSummary
         *        A brief summary of the incident. This typically contains what has happened, what's currently
         *        happening, and next steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateSummary(String incidentTemplateSummary);

        /**
         * <p>
         * Tags to assign to the template. When the <code>StartIncident</code> API action is called, Incident Manager
         * assigns the tags specified in the template to the incident. To call this action, you must also have
         * permission to call the <code>TagResource</code> API action for the incident record resource.
         * </p>
         * 
         * @param incidentTemplateTags
         *        Tags to assign to the template. When the <code>StartIncident</code> API action is called, Incident
         *        Manager assigns the tags specified in the template to the incident. To call this action, you must also
         *        have permission to call the <code>TagResource</code> API action for the incident record resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateTags(Map<String, String> incidentTemplateTags);

        /**
         * <p>
         * The short format name of the incident. The title can't contain spaces.
         * </p>
         * 
         * @param incidentTemplateTitle
         *        The short format name of the incident. The title can't contain spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplateTitle(String incidentTemplateTitle);

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * 
         * @param integrations
         *        Information about third-party services integrated into the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Collection<Integration> integrations);

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * 
         * @param integrations
         *        Information about third-party services integrated into the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Integration... integrations);

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmincidents.model.Integration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder#build()} is called immediately
         * and its result is passed to {@link #integrations(List<Integration>)}.
         * 
         * @param integrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(java.util.Collection<Integration>)
         */
        Builder integrations(Consumer<Integration.Builder>... integrations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private ChatChannel chatChannel;

        private String clientToken;

        private String displayName;

        private List<String> engagements = DefaultSdkAutoConstructList.getInstance();

        private String incidentTemplateDedupeString;

        private Integer incidentTemplateImpact;

        private List<NotificationTargetItem> incidentTemplateNotificationTargets = DefaultSdkAutoConstructList.getInstance();

        private String incidentTemplateSummary;

        private Map<String, String> incidentTemplateTags = DefaultSdkAutoConstructMap.getInstance();

        private String incidentTemplateTitle;

        private List<Integration> integrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResponsePlanRequest model) {
            super(model);
            actions(model.actions);
            arn(model.arn);
            chatChannel(model.chatChannel);
            clientToken(model.clientToken);
            displayName(model.displayName);
            engagements(model.engagements);
            incidentTemplateDedupeString(model.incidentTemplateDedupeString);
            incidentTemplateImpact(model.incidentTemplateImpact);
            incidentTemplateNotificationTargets(model.incidentTemplateNotificationTargets);
            incidentTemplateSummary(model.incidentTemplateSummary);
            incidentTemplateTags(model.incidentTemplateTags);
            incidentTemplateTitle(model.incidentTemplateTitle);
            integrations(model.integrations);
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return chatChannel != null ? chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getEngagements() {
            if (engagements instanceof SdkAutoConstructList) {
                return null;
            }
            return engagements;
        }

        public final void setEngagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
        }

        @Override
        public final Builder engagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(String... engagements) {
            engagements(Arrays.asList(engagements));
            return this;
        }

        public final String getIncidentTemplateDedupeString() {
            return incidentTemplateDedupeString;
        }

        public final void setIncidentTemplateDedupeString(String incidentTemplateDedupeString) {
            this.incidentTemplateDedupeString = incidentTemplateDedupeString;
        }

        @Override
        public final Builder incidentTemplateDedupeString(String incidentTemplateDedupeString) {
            this.incidentTemplateDedupeString = incidentTemplateDedupeString;
            return this;
        }

        public final Integer getIncidentTemplateImpact() {
            return incidentTemplateImpact;
        }

        public final void setIncidentTemplateImpact(Integer incidentTemplateImpact) {
            this.incidentTemplateImpact = incidentTemplateImpact;
        }

        @Override
        public final Builder incidentTemplateImpact(Integer incidentTemplateImpact) {
            this.incidentTemplateImpact = incidentTemplateImpact;
            return this;
        }

        public final List<NotificationTargetItem.Builder> getIncidentTemplateNotificationTargets() {
            List<NotificationTargetItem.Builder> result = NotificationTargetSetCopier
                    .copyToBuilder(this.incidentTemplateNotificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentTemplateNotificationTargets(
                Collection<NotificationTargetItem.BuilderImpl> incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets = NotificationTargetSetCopier
                    .copyFromBuilder(incidentTemplateNotificationTargets);
        }

        @Override
        public final Builder incidentTemplateNotificationTargets(
                Collection<NotificationTargetItem> incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets = NotificationTargetSetCopier.copy(incidentTemplateNotificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentTemplateNotificationTargets(NotificationTargetItem... incidentTemplateNotificationTargets) {
            incidentTemplateNotificationTargets(Arrays.asList(incidentTemplateNotificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentTemplateNotificationTargets(
                Consumer<NotificationTargetItem.Builder>... incidentTemplateNotificationTargets) {
            incidentTemplateNotificationTargets(Stream.of(incidentTemplateNotificationTargets)
                    .map(c -> NotificationTargetItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIncidentTemplateSummary() {
            return incidentTemplateSummary;
        }

        public final void setIncidentTemplateSummary(String incidentTemplateSummary) {
            this.incidentTemplateSummary = incidentTemplateSummary;
        }

        @Override
        public final Builder incidentTemplateSummary(String incidentTemplateSummary) {
            this.incidentTemplateSummary = incidentTemplateSummary;
            return this;
        }

        public final Map<String, String> getIncidentTemplateTags() {
            if (incidentTemplateTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return incidentTemplateTags;
        }

        public final void setIncidentTemplateTags(Map<String, String> incidentTemplateTags) {
            this.incidentTemplateTags = TagMapUpdateCopier.copy(incidentTemplateTags);
        }

        @Override
        public final Builder incidentTemplateTags(Map<String, String> incidentTemplateTags) {
            this.incidentTemplateTags = TagMapUpdateCopier.copy(incidentTemplateTags);
            return this;
        }

        public final String getIncidentTemplateTitle() {
            return incidentTemplateTitle;
        }

        public final void setIncidentTemplateTitle(String incidentTemplateTitle) {
            this.incidentTemplateTitle = incidentTemplateTitle;
        }

        @Override
        public final Builder incidentTemplateTitle(String incidentTemplateTitle) {
            this.incidentTemplateTitle = incidentTemplateTitle;
            return this;
        }

        public final List<Integration.Builder> getIntegrations() {
            List<Integration.Builder> result = IntegrationsCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<Integration.BuilderImpl> integrations) {
            this.integrations = IntegrationsCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<Integration> integrations) {
            this.integrations = IntegrationsCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Integration... integrations) {
            integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<Integration.Builder>... integrations) {
            integrations(Stream.of(integrations).map(c -> Integration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResponsePlanRequest build() {
            return new UpdateResponsePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
