/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReplicationSetsResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<ListReplicationSetsResponse.Builder, ListReplicationSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReplicationSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> REPLICATION_SET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationSetArns")
            .getter(getter(ListReplicationSetsResponse::replicationSetArns))
            .setter(setter(Builder::replicationSetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationSetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REPLICATION_SET_ARNS_FIELD));

    private final String nextToken;

    private final List<String> replicationSetArns;

    private ListReplicationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.replicationSetArns = builder.replicationSetArns;
    }

    /**
     * <p>
     * The pagination token to use when requesting the next set of items. If there are no additional items to return,
     * the string is null.
     * </p>
     * 
     * @return The pagination token to use when requesting the next set of items. If there are no additional items to
     *         return, the string is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationSetArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationSetArns() {
        return replicationSetArns != null && !(replicationSetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the list replication set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationSetArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the list replication set.
     */
    public final List<String> replicationSetArns() {
        return replicationSetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationSetArns() ? replicationSetArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplicationSetsResponse)) {
            return false;
        }
        ListReplicationSetsResponse other = (ListReplicationSetsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReplicationSetArns() == other.hasReplicationSetArns()
                && Objects.equals(replicationSetArns(), other.replicationSetArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReplicationSetsResponse").add("NextToken", nextToken())
                .add("ReplicationSetArns", hasReplicationSetArns() ? replicationSetArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "replicationSetArns":
            return Optional.ofNullable(clazz.cast(replicationSetArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReplicationSetsResponse, T> g) {
        return obj -> g.apply((ListReplicationSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReplicationSetsResponse> {
        /**
         * <p>
         * The pagination token to use when requesting the next set of items. If there are no additional items to
         * return, the string is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use when requesting the next set of items. If there are no additional items to
         *        return, the string is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the list replication set.
         * </p>
         * 
         * @param replicationSetArns
         *        The Amazon Resource Name (ARN) of the list replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSetArns(Collection<String> replicationSetArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the list replication set.
         * </p>
         * 
         * @param replicationSetArns
         *        The Amazon Resource Name (ARN) of the list replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSetArns(String... replicationSetArns);
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> replicationSetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplicationSetsResponse model) {
            super(model);
            nextToken(model.nextToken);
            replicationSetArns(model.replicationSetArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getReplicationSetArns() {
            if (replicationSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationSetArns;
        }

        public final void setReplicationSetArns(Collection<String> replicationSetArns) {
            this.replicationSetArns = ReplicationSetArnListCopier.copy(replicationSetArns);
        }

        @Override
        public final Builder replicationSetArns(Collection<String> replicationSetArns) {
            this.replicationSetArns = ReplicationSetArnListCopier.copy(replicationSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationSetArns(String... replicationSetArns) {
            replicationSetArns(Arrays.asList(replicationSetArns));
            return this;
        }

        @Override
        public ListReplicationSetsResponse build() {
            return new ListReplicationSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
