/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIncidentRecordResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<GetIncidentRecordResponse.Builder, GetIncidentRecordResponse> {
    private static final SdkField<IncidentRecord> INCIDENT_RECORD_FIELD = SdkField
            .<IncidentRecord> builder(MarshallingType.SDK_POJO).memberName("incidentRecord")
            .getter(getter(GetIncidentRecordResponse::incidentRecord)).setter(setter(Builder::incidentRecord))
            .constructor(IncidentRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCIDENT_RECORD_FIELD));

    private final IncidentRecord incidentRecord;

    private GetIncidentRecordResponse(BuilderImpl builder) {
        super(builder);
        this.incidentRecord = builder.incidentRecord;
    }

    /**
     * <p>
     * Details the structure of the incident record.
     * </p>
     * 
     * @return Details the structure of the incident record.
     */
    public final IncidentRecord incidentRecord() {
        return incidentRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIncidentRecordResponse)) {
            return false;
        }
        GetIncidentRecordResponse other = (GetIncidentRecordResponse) obj;
        return Objects.equals(incidentRecord(), other.incidentRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIncidentRecordResponse").add("IncidentRecord", incidentRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "incidentRecord":
            return Optional.ofNullable(clazz.cast(incidentRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIncidentRecordResponse, T> g) {
        return obj -> g.apply((GetIncidentRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIncidentRecordResponse> {
        /**
         * <p>
         * Details the structure of the incident record.
         * </p>
         * 
         * @param incidentRecord
         *        Details the structure of the incident record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecord(IncidentRecord incidentRecord);

        /**
         * <p>
         * Details the structure of the incident record.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncidentRecord.Builder} avoiding the need
         * to create one manually via {@link IncidentRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncidentRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #incidentRecord(IncidentRecord)}.
         * 
         * @param incidentRecord
         *        a consumer that will call methods on {@link IncidentRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentRecord(IncidentRecord)
         */
        default Builder incidentRecord(Consumer<IncidentRecord.Builder> incidentRecord) {
            return incidentRecord(IncidentRecord.builder().applyMutation(incidentRecord).build());
        }
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private IncidentRecord incidentRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIncidentRecordResponse model) {
            super(model);
            incidentRecord(model.incidentRecord);
        }

        public final IncidentRecord.Builder getIncidentRecord() {
            return incidentRecord != null ? incidentRecord.toBuilder() : null;
        }

        public final void setIncidentRecord(IncidentRecord.BuilderImpl incidentRecord) {
            this.incidentRecord = incidentRecord != null ? incidentRecord.build() : null;
        }

        @Override
        public final Builder incidentRecord(IncidentRecord incidentRecord) {
            this.incidentRecord = incidentRecord;
            return this;
        }

        @Override
        public GetIncidentRecordResponse build() {
            return new GetIncidentRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
