/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetIncidentFindingsResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<BatchGetIncidentFindingsResponse.Builder, BatchGetIncidentFindingsResponse> {
    private static final SdkField<List<BatchGetIncidentFindingsError>> ERRORS_FIELD = SdkField
            .<List<BatchGetIncidentFindingsError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetIncidentFindingsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetIncidentFindingsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetIncidentFindingsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField
            .<List<Finding>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(BatchGetIncidentFindingsResponse::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Finding> builder(MarshallingType.SDK_POJO)
                                            .constructor(Finding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, FINDINGS_FIELD));

    private final List<BatchGetIncidentFindingsError> errors;

    private final List<Finding> findings;

    private BatchGetIncidentFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.findings = builder.findings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors encountered during the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors encountered during the operation.
     */
    public final List<BatchGetIncidentFindingsError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Findings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindings} method.
     * </p>
     * 
     * @return Information about the requested findings.
     */
    public final List<Finding> findings() {
        return findings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetIncidentFindingsResponse)) {
            return false;
        }
        BatchGetIncidentFindingsResponse other = (BatchGetIncidentFindingsResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetIncidentFindingsResponse").add("Errors", hasErrors() ? errors() : null)
                .add("Findings", hasFindings() ? findings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetIncidentFindingsResponse, T> g) {
        return obj -> g.apply((BatchGetIncidentFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetIncidentFindingsResponse> {
        /**
         * <p>
         * A list of errors encountered during the operation.
         * </p>
         * 
         * @param errors
         *        A list of errors encountered during the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetIncidentFindingsError> errors);

        /**
         * <p>
         * A list of errors encountered during the operation.
         * </p>
         * 
         * @param errors
         *        A list of errors encountered during the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetIncidentFindingsError... errors);

        /**
         * <p>
         * A list of errors encountered during the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchGetIncidentFindingsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetIncidentFindingsError>)
         */
        Builder errors(Consumer<BatchGetIncidentFindingsError.Builder>... errors);

        /**
         * <p>
         * Information about the requested findings.
         * </p>
         * 
         * @param findings
         *        Information about the requested findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<Finding> findings);

        /**
         * <p>
         * Information about the requested findings.
         * </p>
         * 
         * @param findings
         *        Information about the requested findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Finding... findings);

        /**
         * <p>
         * Information about the requested findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Finding.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmincidents.model.Finding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Finding.Builder#build()} is called immediately and
         * its result is passed to {@link #findings(List<Finding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Finding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(java.util.Collection<Finding>)
         */
        Builder findings(Consumer<Finding.Builder>... findings);
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private List<BatchGetIncidentFindingsError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetIncidentFindingsResponse model) {
            super(model);
            errors(model.errors);
            findings(model.findings);
        }

        public final List<BatchGetIncidentFindingsError.Builder> getErrors() {
            List<BatchGetIncidentFindingsError.Builder> result = BatchGetIncidentFindingsErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetIncidentFindingsError.BuilderImpl> errors) {
            this.errors = BatchGetIncidentFindingsErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetIncidentFindingsError> errors) {
            this.errors = BatchGetIncidentFindingsErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetIncidentFindingsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetIncidentFindingsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetIncidentFindingsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingListCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingListCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> Finding.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetIncidentFindingsResponse build() {
            return new BatchGetIncidentFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
