/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetIncidentFindingsRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<BatchGetIncidentFindingsRequest.Builder, BatchGetIncidentFindingsRequest> {
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("findingIds")
            .getter(getter(BatchGetIncidentFindingsRequest::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentRecordArn").getter(getter(BatchGetIncidentFindingsRequest::incidentRecordArn))
            .setter(setter(Builder::incidentRecordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDS_FIELD,
            INCIDENT_RECORD_ARN_FIELD));

    private final List<String> findingIds;

    private final String incidentRecordArn;

    private BatchGetIncidentFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIds = builder.findingIds;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs of findings for which you want to view details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingIds} method.
     * </p>
     * 
     * @return A list of IDs of findings for which you want to view details.
     */
    public final List<String> findingIds() {
        return findingIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident for which you want to view finding details.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident for which you want to view finding details.
     */
    public final String incidentRecordArn() {
        return incidentRecordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIds() ? findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetIncidentFindingsRequest)) {
            return false;
        }
        BatchGetIncidentFindingsRequest other = (BatchGetIncidentFindingsRequest) obj;
        return hasFindingIds() == other.hasFindingIds() && Objects.equals(findingIds(), other.findingIds())
                && Objects.equals(incidentRecordArn(), other.incidentRecordArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetIncidentFindingsRequest").add("FindingIds", hasFindingIds() ? findingIds() : null)
                .add("IncidentRecordArn", incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "incidentRecordArn":
            return Optional.ofNullable(clazz.cast(incidentRecordArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetIncidentFindingsRequest, T> g) {
        return obj -> g.apply((BatchGetIncidentFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetIncidentFindingsRequest> {
        /**
         * <p>
         * A list of IDs of findings for which you want to view details.
         * </p>
         * 
         * @param findingIds
         *        A list of IDs of findings for which you want to view details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * A list of IDs of findings for which you want to view details.
         * </p>
         * 
         * @param findingIds
         *        A list of IDs of findings for which you want to view details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident for which you want to view finding details.
         * </p>
         * 
         * @param incidentRecordArn
         *        The Amazon Resource Name (ARN) of the incident for which you want to view finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordArn(String incidentRecordArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetIncidentFindingsRequest model) {
            super(model);
            findingIds(model.findingIds);
            incidentRecordArn(model.incidentRecordArn);
        }

        public final Collection<String> getFindingIds() {
            if (findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return findingIds;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdListCopier.copy(findingIds);
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdListCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final String getIncidentRecordArn() {
            return incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetIncidentFindingsRequest build() {
            return new BatchGetIncidentFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
