/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageResolutionsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageResolutionsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact;

public class ListPageResolutionsPublisher
implements SdkPublisher<ListPageResolutionsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListPageResolutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPageResolutionsPublisher(SsmContactsAsyncClient client, ListPageResolutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPageResolutionsPublisher(SsmContactsAsyncClient client, ListPageResolutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPageResolutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPageResolutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolutionContact> pageResolutions() {
        Function<ListPageResolutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pageResolutions() != null) {
                return response.pageResolutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPageResolutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPageResolutionsResponseFetcher
    implements AsyncPageFetcher<ListPageResolutionsResponse> {
        private ListPageResolutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPageResolutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPageResolutionsResponse> nextPage(ListPageResolutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPageResolutionsPublisher.this.client.listPageResolutions(ListPageResolutionsPublisher.this.firstRequest);
            }
            return ListPageResolutionsPublisher.this.client.listPageResolutions((ListPageResolutionsRequest)((Object)ListPageResolutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

