/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListNodesRequest;
import software.amazon.awssdk.services.ssm.model.ListNodesResponse;
import software.amazon.awssdk.services.ssm.model.Node;

public class ListNodesIterable
implements SdkIterable<ListNodesResponse> {
    private final SsmClient client;
    private final ListNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNodesIterable(SsmClient client, ListNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNodesResponseFetcher();
    }

    public Iterator<ListNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Node> nodes() {
        Function<ListNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNodesResponseFetcher
    implements SyncPageFetcher<ListNodesResponse> {
        private ListNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNodesResponse nextPage(ListNodesResponse previousPage) {
            if (previousPage == null) {
                return ListNodesIterable.this.client.listNodes(ListNodesIterable.this.firstRequest);
            }
            return ListNodesIterable.this.client.listNodes((ListNodesRequest)((Object)ListNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

