/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;

public class GetParameterHistoryPublisher
implements SdkPublisher<GetParameterHistoryResponse> {
    private final SsmAsyncClient client;
    private final GetParameterHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetParameterHistoryPublisher(SsmAsyncClient client, GetParameterHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetParameterHistoryPublisher(SsmAsyncClient client, GetParameterHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetParameterHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetParameterHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetParameterHistoryResponseFetcher
    implements AsyncPageFetcher<GetParameterHistoryResponse> {
        private GetParameterHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetParameterHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetParameterHistoryResponse> nextPage(GetParameterHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetParameterHistoryPublisher.this.client.getParameterHistory(GetParameterHistoryPublisher.this.firstRequest);
            }
            return GetParameterHistoryPublisher.this.client.getParameterHistory((GetParameterHistoryRequest)((Object)GetParameterHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

