/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse;
import software.amazon.awssdk.services.ssm.model.InstanceProperty;

public class DescribeInstancePropertiesIterable
implements SdkIterable<DescribeInstancePropertiesResponse> {
    private final SsmClient client;
    private final DescribeInstancePropertiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancePropertiesIterable(SsmClient client, DescribeInstancePropertiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstancePropertiesResponseFetcher();
    }

    public Iterator<DescribeInstancePropertiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceProperty> instanceProperties() {
        Function<DescribeInstancePropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProperties() != null) {
                return response.instanceProperties().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstancePropertiesResponseFetcher
    implements SyncPageFetcher<DescribeInstancePropertiesResponse> {
        private DescribeInstancePropertiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancePropertiesResponse nextPage(DescribeInstancePropertiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePropertiesIterable.this.client.describeInstanceProperties(DescribeInstancePropertiesIterable.this.firstRequest);
            }
            return DescribeInstancePropertiesIterable.this.client.describeInstanceProperties((DescribeInstancePropertiesRequest)((Object)DescribeInstancePropertiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

