/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;

public class DescribeInstancePatchStatesForPatchGroupIterable
implements SdkIterable<DescribeInstancePatchStatesForPatchGroupResponse> {
    private final SsmClient client;
    private final DescribeInstancePatchStatesForPatchGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancePatchStatesForPatchGroupIterable(SsmClient client, DescribeInstancePatchStatesForPatchGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstancePatchStatesForPatchGroupResponseFetcher();
    }

    public Iterator<DescribeInstancePatchStatesForPatchGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstancePatchState> instancePatchStates() {
        Function<DescribeInstancePatchStatesForPatchGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.instancePatchStates() != null) {
                return response.instancePatchStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstancePatchStatesForPatchGroupResponseFetcher
    implements SyncPageFetcher<DescribeInstancePatchStatesForPatchGroupResponse> {
        private DescribeInstancePatchStatesForPatchGroupResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePatchStatesForPatchGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancePatchStatesForPatchGroupResponse nextPage(DescribeInstancePatchStatesForPatchGroupResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePatchStatesForPatchGroupIterable.this.client.describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupIterable.this.firstRequest);
            }
            return DescribeInstancePatchStatesForPatchGroupIterable.this.client.describeInstancePatchStatesForPatchGroup((DescribeInstancePatchStatesForPatchGroupRequest)((Object)DescribeInstancePatchStatesForPatchGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

