/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;

public class DescribeEffectivePatchesForPatchBaselineIterable
implements SdkIterable<DescribeEffectivePatchesForPatchBaselineResponse> {
    private final SsmClient client;
    private final DescribeEffectivePatchesForPatchBaselineRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEffectivePatchesForPatchBaselineIterable(SsmClient client, DescribeEffectivePatchesForPatchBaselineRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEffectivePatchesForPatchBaselineResponseFetcher();
    }

    public Iterator<DescribeEffectivePatchesForPatchBaselineResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EffectivePatch> effectivePatches() {
        Function<DescribeEffectivePatchesForPatchBaselineResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectivePatches() != null) {
                return response.effectivePatches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEffectivePatchesForPatchBaselineResponseFetcher
    implements SyncPageFetcher<DescribeEffectivePatchesForPatchBaselineResponse> {
        private DescribeEffectivePatchesForPatchBaselineResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEffectivePatchesForPatchBaselineResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEffectivePatchesForPatchBaselineResponse nextPage(DescribeEffectivePatchesForPatchBaselineResponse previousPage) {
            if (previousPage == null) {
                return DescribeEffectivePatchesForPatchBaselineIterable.this.client.describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineIterable.this.firstRequest);
            }
            return DescribeEffectivePatchesForPatchBaselineIterable.this.client.describeEffectivePatchesForPatchBaseline((DescribeEffectivePatchesForPatchBaselineRequest)((Object)DescribeEffectivePatchesForPatchBaselineIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

