/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSessionResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, StartSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StartSessionResponse.getter(StartSessionResponse::sessionId)).setter(StartSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> TOKEN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenValue").getter(StartSessionResponse.getter(StartSessionResponse::tokenValue)).setter(StartSessionResponse.setter(Builder::tokenValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValue").build()}).build();
    private static final SdkField<String> STREAM_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamUrl").getter(StartSessionResponse.getter(StartSessionResponse::streamUrl)).setter(StartSessionResponse.setter(Builder::streamUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, TOKEN_VALUE_FIELD, STREAM_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSessionResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String tokenValue;
    private final String streamUrl;

    private StartSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.tokenValue = builder.tokenValue;
        this.streamUrl = builder.streamUrl;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String tokenValue() {
        return this.tokenValue;
    }

    public final String streamUrl() {
        return this.streamUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionResponse)) {
            return false;
        }
        StartSessionResponse other = (StartSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.tokenValue(), other.tokenValue()) && Objects.equals(this.streamUrl(), other.streamUrl());
    }

    public final String toString() {
        return ToString.builder((String)"StartSessionResponse").add("SessionId", (Object)this.sessionId()).add("TokenValue", (Object)this.tokenValue()).add("StreamUrl", (Object)this.streamUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "TokenValue": {
                return Optional.ofNullable(clazz.cast(this.tokenValue()));
            }
            case "StreamUrl": {
                return Optional.ofNullable(clazz.cast(this.streamUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("TokenValue", TOKEN_VALUE_FIELD);
        map.put("StreamUrl", STREAM_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSessionResponse, T> g) {
        return obj -> g.apply((StartSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String tokenValue;
        private String streamUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.tokenValue(model.tokenValue);
            this.streamUrl(model.streamUrl);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTokenValue() {
            return this.tokenValue;
        }

        public final void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @Override
        public final Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public final String getStreamUrl() {
            return this.streamUrl;
        }

        public final void setStreamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        @Override
        public final Builder streamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        @Override
        public StartSessionResponse build() {
            return new StartSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSessionResponse> {
        public Builder sessionId(String var1);

        public Builder tokenValue(String var1);

        public Builder streamUrl(String var1);
    }
}

