/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeAggregatorType {
    COUNT("Count"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeAggregatorType> VALUE_MAP;
    private final String value;

    private NodeAggregatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeAggregatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeAggregatorType> knownValues() {
        EnumSet<NodeAggregatorType> knownValues = EnumSet.allOf(NodeAggregatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeAggregatorType.class, NodeAggregatorType::toString);
    }
}

