/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetDocumentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDocumentRequest.getter(GetDocumentRequest::name)).setter(GetDocumentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(GetDocumentRequest.getter(GetDocumentRequest::versionName)).setter(GetDocumentRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(GetDocumentRequest.getter(GetDocumentRequest::documentVersion)).setter(GetDocumentRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentFormat").getter(GetDocumentRequest.getter(GetDocumentRequest::documentFormatAsString)).setter(GetDocumentRequest.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_NAME_FIELD, DOCUMENT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDocumentRequest.memberNameToFieldInitializer();
    private final String name;
    private final String versionName;
    private final String documentVersion;
    private final String documentFormat;

    private GetDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.documentVersion = builder.documentVersion;
        this.documentFormat = builder.documentFormat;
    }

    public final String name() {
        return this.name;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public final String documentFormatAsString() {
        return this.documentFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentRequest)) {
            return false;
        }
        GetDocumentRequest other = (GetDocumentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDocumentRequest").add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("DocumentVersion", (Object)this.documentVersion()).add("DocumentFormat", (Object)this.documentFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("VersionName", VERSION_NAME_FIELD);
        map.put("DocumentVersion", DOCUMENT_VERSION_FIELD);
        map.put("DocumentFormat", DOCUMENT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentRequest, T> g) {
        return obj -> g.apply((GetDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String versionName;
        private String documentVersion;
        private String documentFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentRequest model) {
            super(model);
            this.name(model.name);
            this.versionName(model.versionName);
            this.documentVersion(model.documentVersion);
            this.documentFormat(model.documentFormat);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getDocumentFormat() {
            return this.documentFormat;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentRequest build() {
            return new GetDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentRequest> {
        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder documentVersion(String var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

