/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDefaultPatchBaselineResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetDefaultPatchBaselineResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(GetDefaultPatchBaselineResponse.getter(GetDefaultPatchBaselineResponse::baselineId)).setter(GetDefaultPatchBaselineResponse.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(GetDefaultPatchBaselineResponse.getter(GetDefaultPatchBaselineResponse::operatingSystemAsString)).setter(GetDefaultPatchBaselineResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, OPERATING_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDefaultPatchBaselineResponse.memberNameToFieldInitializer();
    private final String baselineId;
    private final String operatingSystem;

    private GetDefaultPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.operatingSystem = builder.operatingSystem;
    }

    public final String baselineId() {
        return this.baselineId;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultPatchBaselineResponse)) {
            return false;
        }
        GetDefaultPatchBaselineResponse other = (GetDefaultPatchBaselineResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDefaultPatchBaselineResponse").add("BaselineId", (Object)this.baselineId()).add("OperatingSystem", (Object)this.operatingSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BaselineId", BASELINE_ID_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultPatchBaselineResponse, T> g) {
        return obj -> g.apply((GetDefaultPatchBaselineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultPatchBaselineResponse model) {
            super(model);
            this.baselineId(model.baselineId);
            this.operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        @Override
        public GetDefaultPatchBaselineResponse build() {
            return new GetDefaultPatchBaselineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDefaultPatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);
    }
}

