/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionStatus {
    CONNECTED("connected"),
    NOTCONNECTED("notconnected"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionStatus> VALUE_MAP;
    private final String value;

    private ConnectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionStatus> knownValues() {
        EnumSet<ConnectionStatus> knownValues = EnumSet.allOf(ConnectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionStatus.class, ConnectionStatus::toString);
    }
}

