/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComplianceSeverity {
    CRITICAL("CRITICAL"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    LOW("LOW"),
    INFORMATIONAL("INFORMATIONAL"),
    UNSPECIFIED("UNSPECIFIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComplianceSeverity> VALUE_MAP;
    private final String value;

    private ComplianceSeverity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComplianceSeverity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComplianceSeverity> knownValues() {
        EnumSet<ComplianceSeverity> knownValues = EnumSet.allOf(ComplianceSeverity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComplianceSeverity.class, ComplianceSeverity::toString);
    }
}

