/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;

public class ListCommandsPublisher
implements SdkPublisher<ListCommandsResponse> {
    private final SsmAsyncClient client;
    private final ListCommandsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommandsPublisher(SsmAsyncClient client, ListCommandsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommandsPublisher(SsmAsyncClient client, ListCommandsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommandsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Command> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commands() != null) {
                return response.commands().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommandsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommandsResponseFetcher
    implements AsyncPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommandsResponse> nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsPublisher.this.client.listCommands(ListCommandsPublisher.this.firstRequest);
            }
            return ListCommandsPublisher.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

