/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;
import software.amazon.awssdk.services.ssm.model.DocumentVersionListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentVersionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListDocumentVersionsResponse> {
    private static final SdkField<List<DocumentVersionInfo>> DOCUMENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentVersions").getter(ListDocumentVersionsResponse.getter(ListDocumentVersionsResponse::documentVersions)).setter(ListDocumentVersionsResponse.setter(Builder::documentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentVersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentVersionsResponse.getter(ListDocumentVersionsResponse::nextToken)).setter(ListDocumentVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDocumentVersionsResponse.memberNameToFieldInitializer();
    private final List<DocumentVersionInfo> documentVersions;
    private final String nextToken;

    private ListDocumentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.documentVersions = builder.documentVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDocumentVersions() {
        return this.documentVersions != null && !(this.documentVersions instanceof SdkAutoConstructList);
    }

    public final List<DocumentVersionInfo> documentVersions() {
        return this.documentVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentVersions() ? this.documentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentVersionsResponse)) {
            return false;
        }
        ListDocumentVersionsResponse other = (ListDocumentVersionsResponse)((Object)obj);
        return this.hasDocumentVersions() == other.hasDocumentVersions() && Objects.equals(this.documentVersions(), other.documentVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentVersionsResponse").add("DocumentVersions", this.hasDocumentVersions() ? this.documentVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentVersions": {
                return Optional.ofNullable(clazz.cast(this.documentVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentVersions", DOCUMENT_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentVersionsResponse, T> g) {
        return obj -> g.apply((ListDocumentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<DocumentVersionInfo> documentVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentVersionsResponse model) {
            super(model);
            this.documentVersions(model.documentVersions);
            this.nextToken(model.nextToken);
        }

        public final List<DocumentVersionInfo.Builder> getDocumentVersions() {
            List<DocumentVersionInfo.Builder> result = DocumentVersionListCopier.copyToBuilder(this.documentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentVersions(Collection<DocumentVersionInfo.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copyFromBuilder(documentVersions);
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionInfo> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionInfo ... documentVersions) {
            this.documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(Consumer<DocumentVersionInfo.Builder> ... documentVersions) {
            this.documentVersions(Stream.of(documentVersions).map(c -> (DocumentVersionInfo)((DocumentVersionInfo.Builder)DocumentVersionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentVersionsResponse build() {
            return new ListDocumentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentVersionsResponse> {
        public Builder documentVersions(Collection<DocumentVersionInfo> var1);

        public Builder documentVersions(DocumentVersionInfo ... var1);

        public Builder documentVersions(Consumer<DocumentVersionInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

