/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommandInvocationRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetCommandInvocationRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommandId").getter(GetCommandInvocationRequest.getter(GetCommandInvocationRequest::commandId)).setter(GetCommandInvocationRequest.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetCommandInvocationRequest.getter(GetCommandInvocationRequest::instanceId)).setter(GetCommandInvocationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginName").getter(GetCommandInvocationRequest.getter(GetCommandInvocationRequest::pluginName)).setter(GetCommandInvocationRequest.setter(Builder::pluginName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, INSTANCE_ID_FIELD, PLUGIN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCommandInvocationRequest.memberNameToFieldInitializer();
    private final String commandId;
    private final String instanceId;
    private final String pluginName;

    private GetCommandInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.pluginName = builder.pluginName;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String pluginName() {
        return this.pluginName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationRequest)) {
            return false;
        }
        GetCommandInvocationRequest other = (GetCommandInvocationRequest)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.pluginName(), other.pluginName());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommandInvocationRequest").add("CommandId", (Object)this.commandId()).add("InstanceId", (Object)this.instanceId()).add("PluginName", (Object)this.pluginName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PluginName": {
                return Optional.ofNullable(clazz.cast(this.pluginName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CommandId", COMMAND_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PluginName", PLUGIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandInvocationRequest, T> g) {
        return obj -> g.apply((GetCommandInvocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String pluginName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationRequest model) {
            super(model);
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.pluginName(model.pluginName);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommandInvocationRequest build() {
            return new GetCommandInvocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommandInvocationRequest> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder pluginName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

