/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;

public class ListResourceComplianceSummariesIterable
implements SdkIterable<ListResourceComplianceSummariesResponse> {
    private final SsmClient client;
    private final ListResourceComplianceSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceComplianceSummariesIterable(SsmClient client, ListResourceComplianceSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceComplianceSummariesResponseFetcher();
    }

    public Iterator<ListResourceComplianceSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        Function<ListResourceComplianceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceComplianceSummaryItems() != null) {
                return response.resourceComplianceSummaryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceComplianceSummariesResponseFetcher
    implements SyncPageFetcher<ListResourceComplianceSummariesResponse> {
        private ListResourceComplianceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceComplianceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceComplianceSummariesResponse nextPage(ListResourceComplianceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceComplianceSummariesIterable.this.client.listResourceComplianceSummaries(ListResourceComplianceSummariesIterable.this.firstRequest);
            }
            return ListResourceComplianceSummariesIterable.this.client.listResourceComplianceSummaries((ListResourceComplianceSummariesRequest)((Object)ListResourceComplianceSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

