/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;

public class ListAssociationVersionsIterable
implements SdkIterable<ListAssociationVersionsResponse> {
    private final SsmClient client;
    private final ListAssociationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociationVersionsIterable(SsmClient client, ListAssociationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssociationVersionsResponseFetcher();
    }

    public Iterator<ListAssociationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociationVersionInfo> associationVersions() {
        Function<ListAssociationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associationVersions() != null) {
                return response.associationVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociationVersionsResponseFetcher
    implements SyncPageFetcher<ListAssociationVersionsResponse> {
        private ListAssociationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociationVersionsResponse nextPage(ListAssociationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationVersionsIterable.this.client.listAssociationVersions(ListAssociationVersionsIterable.this.firstRequest);
            }
            return ListAssociationVersionsIterable.this.client.listAssociationVersions((ListAssociationVersionsRequest)((Object)ListAssociationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

