/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry;

public class GetResourcePoliciesIterable
implements SdkIterable<GetResourcePoliciesResponse> {
    private final SsmClient client;
    private final GetResourcePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcePoliciesIterable(SsmClient client, GetResourcePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetResourcePoliciesResponseFetcher();
    }

    public Iterator<GetResourcePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GetResourcePoliciesResponseEntry> policies() {
        Function<GetResourcePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourcePoliciesResponseFetcher
    implements SyncPageFetcher<GetResourcePoliciesResponse> {
        private GetResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourcePoliciesResponse nextPage(GetResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcePoliciesIterable.this.client.getResourcePolicies(GetResourcePoliciesIterable.this.firstRequest);
            }
            return GetResourcePoliciesIterable.this.client.getResourcePolicies((GetResourcePoliciesRequest)((Object)GetResourcePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

