/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemSummary;

public class DescribeOpsItemsIterable
implements SdkIterable<DescribeOpsItemsResponse> {
    private final SsmClient client;
    private final DescribeOpsItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOpsItemsIterable(SsmClient client, DescribeOpsItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOpsItemsResponseFetcher();
    }

    public Iterator<DescribeOpsItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpsItemSummary> opsItemSummaries() {
        Function<DescribeOpsItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.opsItemSummaries() != null) {
                return response.opsItemSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOpsItemsResponseFetcher
    implements SyncPageFetcher<DescribeOpsItemsResponse> {
        private DescribeOpsItemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOpsItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOpsItemsResponse nextPage(DescribeOpsItemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOpsItemsIterable.this.client.describeOpsItems(DescribeOpsItemsIterable.this.firstRequest);
            }
            return DescribeOpsItemsIterable.this.client.describeOpsItems((DescribeOpsItemsRequest)((Object)DescribeOpsItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

