/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;

public class DescribeInstancePatchesPublisher
implements SdkPublisher<DescribeInstancePatchesResponse> {
    private final SsmAsyncClient client;
    private final DescribeInstancePatchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstancePatchesPublisher(SsmAsyncClient client, DescribeInstancePatchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstancePatchesPublisher(SsmAsyncClient client, DescribeInstancePatchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstancePatchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstancePatchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PatchComplianceData> patches() {
        Function<DescribeInstancePatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.patches() != null) {
                return response.patches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstancePatchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstancePatchesResponseFetcher
    implements AsyncPageFetcher<DescribeInstancePatchesResponse> {
        private DescribeInstancePatchesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstancePatchesResponse> nextPage(DescribeInstancePatchesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePatchesPublisher.this.client.describeInstancePatches(DescribeInstancePatchesPublisher.this.firstRequest);
            }
            return DescribeInstancePatchesPublisher.this.client.describeInstancePatches((DescribeInstancePatchesRequest)((Object)DescribeInstancePatchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

