/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;

public class DescribeMaintenanceWindowTargetsPublisher
implements SdkPublisher<DescribeMaintenanceWindowTargetsResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowTargetsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowTargetsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowTarget> targets() {
        Function<DescribeMaintenanceWindowTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMaintenanceWindowTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMaintenanceWindowTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowTargetsResponse> {
        private DescribeMaintenanceWindowTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowTargetsResponse> nextPage(DescribeMaintenanceWindowTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowTargetsPublisher.this.client.describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowTargetsPublisher.this.client.describeMaintenanceWindowTargets((DescribeMaintenanceWindowTargetsRequest)((Object)DescribeMaintenanceWindowTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

