/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowTask> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::windowId)).setter(MaintenanceWindowTask.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> WINDOW_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowTaskId").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::windowTaskId)).setter(MaintenanceWindowTask.setter(Builder::windowTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTaskId").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::taskArn)).setter(MaintenanceWindowTask.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::typeAsString)).setter(MaintenanceWindowTask.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::targets)).setter(MaintenanceWindowTask.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, MaintenanceWindowTaskParameterValueExpression>> TASK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TaskParameters").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::taskParameters)).setter(MaintenanceWindowTask.setter(Builder::taskParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowTaskParameterValueExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::priority)).setter(MaintenanceWindowTask.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::loggingInfo)).setter(MaintenanceWindowTask.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingInfo").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::serviceRoleArn)).setter(MaintenanceWindowTask.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::maxConcurrency)).setter(MaintenanceWindowTask.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::maxErrors)).setter(MaintenanceWindowTask.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::name)).setter(MaintenanceWindowTask.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::description)).setter(MaintenanceWindowTask.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CUTOFF_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CutoffBehavior").getter(MaintenanceWindowTask.getter(MaintenanceWindowTask::cutoffBehaviorAsString)).setter(MaintenanceWindowTask.setter(Builder::cutoffBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CutoffBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, WINDOW_TASK_ID_FIELD, TASK_ARN_FIELD, TYPE_FIELD, TARGETS_FIELD, TASK_PARAMETERS_FIELD, PRIORITY_FIELD, LOGGING_INFO_FIELD, SERVICE_ROLE_ARN_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CUTOFF_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String windowTaskId;
    private final String taskArn;
    private final String type;
    private final List<Target> targets;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final Integer priority;
    private final LoggingInfo loggingInfo;
    private final String serviceRoleArn;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String name;
    private final String description;
    private final String cutoffBehavior;

    private MaintenanceWindowTask(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.taskArn = builder.taskArn;
        this.type = builder.type;
        this.targets = builder.targets;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.loggingInfo = builder.loggingInfo;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.name = builder.name;
        this.description = builder.description;
        this.cutoffBehavior = builder.cutoffBehavior;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final String windowTaskId() {
        return this.windowTaskId;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final MaintenanceWindowTaskType type() {
        return MaintenanceWindowTaskType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final boolean hasTaskParameters() {
        return this.taskParameters != null && !(this.taskParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final MaintenanceWindowTaskCutoffBehavior cutoffBehavior() {
        return MaintenanceWindowTaskCutoffBehavior.fromValue(this.cutoffBehavior);
    }

    public final String cutoffBehaviorAsString() {
        return this.cutoffBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskParameters() ? this.taskParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoffBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTask)) {
            return false;
        }
        MaintenanceWindowTask other = (MaintenanceWindowTask)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTaskId(), other.windowTaskId()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTaskParameters() == other.hasTaskParameters() && Objects.equals(this.taskParameters(), other.taskParameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cutoffBehaviorAsString(), other.cutoffBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowTask").add("WindowId", (Object)this.windowId()).add("WindowTaskId", (Object)this.windowTaskId()).add("TaskArn", (Object)this.taskArn()).add("Type", (Object)this.typeAsString()).add("Targets", this.hasTargets() ? this.targets() : null).add("TaskParameters", (Object)(this.taskParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Priority", (Object)this.priority()).add("LoggingInfo", (Object)this.loggingInfo()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CutoffBehavior", (Object)this.cutoffBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowTaskId": {
                return Optional.ofNullable(clazz.cast(this.windowTaskId()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TaskParameters": {
                return Optional.ofNullable(clazz.cast(this.taskParameters()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CutoffBehavior": {
                return Optional.ofNullable(clazz.cast(this.cutoffBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowTask, T> g) {
        return obj -> g.apply((MaintenanceWindowTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTaskId;
        private String taskArn;
        private String type;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer priority;
        private LoggingInfo loggingInfo;
        private String serviceRoleArn;
        private String maxConcurrency;
        private String maxErrors;
        private String name;
        private String description;
        private String cutoffBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTask model) {
            this.windowId(model.windowId);
            this.windowTaskId(model.windowTaskId);
            this.taskArn(model.taskArn);
            this.type(model.type);
            this.targets(model.targets);
            this.taskParameters(model.taskParameters);
            this.priority(model.priority);
            this.loggingInfo(model.loggingInfo);
            this.serviceRoleArn(model.serviceRoleArn);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.name(model.name);
            this.description(model.description);
            this.cutoffBehavior(model.cutoffBehavior);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getWindowTaskId() {
            return this.windowTaskId;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowTaskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> result = MaintenanceWindowTaskParametersCopier.copyToBuilder(this.taskParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCutoffBehavior() {
            return this.cutoffBehavior;
        }

        public final void setCutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
        }

        @Override
        public final Builder cutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
            return this;
        }

        @Override
        public final Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior cutoffBehavior) {
            this.cutoffBehavior(cutoffBehavior == null ? null : cutoffBehavior.toString());
            return this;
        }

        public MaintenanceWindowTask build() {
            return new MaintenanceWindowTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowTask> {
        public Builder windowId(String var1);

        public Builder windowTaskId(String var1);

        public Builder taskArn(String var1);

        public Builder type(String var1);

        public Builder type(MaintenanceWindowTaskType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder priority(Integer var1);

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder serviceRoleArn(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder cutoffBehavior(String var1);

        public Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior var1);
    }
}

