/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.IdentifiableMessage;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchManager;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;
import software.amazon.awssdk.utils.Either;

@SdkInternalApi
public class DeleteMessageBatchManager
extends RequestBatchManager<DeleteMessageRequest, DeleteMessageResponse, DeleteMessageBatchResponse> {
    private final SqsAsyncClient sqsAsyncClient;

    protected DeleteMessageBatchManager(RequestBatchConfiguration overrideConfiguration, ScheduledExecutorService scheduledExecutor, SqsAsyncClient sqsAsyncClient) {
        super(overrideConfiguration, scheduledExecutor);
        this.sqsAsyncClient = sqsAsyncClient;
    }

    private static DeleteMessageBatchRequest createDeleteMessageBatchRequest(List<IdentifiableMessage<DeleteMessageRequest>> identifiedRequests, String batchKey) {
        List entries = identifiedRequests.stream().map(identifiedRequest -> DeleteMessageBatchManager.createDeleteMessageBatchRequestEntry(identifiedRequest.id(), (DeleteMessageRequest)((Object)((Object)identifiedRequest.message())))).collect(Collectors.toList());
        Optional overrideConfiguration = identifiedRequests.get(0).message().overrideConfiguration();
        return overrideConfiguration.map(overrideConfig -> (DeleteMessageBatchRequest)((Object)((Object)DeleteMessageBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)overrideConfig.toBuilder().applyMutation(USER_AGENT_APPLIER)).build()).entries(entries).build()))).orElseGet(() -> (DeleteMessageBatchRequest)((Object)((Object)DeleteMessageBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(o -> ((AwsRequestOverrideConfiguration.Builder)o.applyMutation(USER_AGENT_APPLIER)).build()).entries(entries).build())));
    }

    private static DeleteMessageBatchRequestEntry createDeleteMessageBatchRequestEntry(String id, DeleteMessageRequest request) {
        return (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(id).receiptHandle(request.receiptHandle()).build();
    }

    private static IdentifiableMessage<DeleteMessageResponse> createDeleteMessageResponse(DeleteMessageBatchResultEntry successfulEntry, DeleteMessageBatchResponse batchResponse) {
        String key = successfulEntry.id();
        DeleteMessageResponse.Builder builder = DeleteMessageResponse.builder();
        if (batchResponse.responseMetadata() != null) {
            builder.responseMetadata(batchResponse.responseMetadata());
        }
        if (batchResponse.sdkHttpResponse() != null) {
            builder.sdkHttpResponse(batchResponse.sdkHttpResponse());
        }
        DeleteMessageResponse response = (DeleteMessageResponse)((Object)builder.build());
        return new IdentifiableMessage<DeleteMessageResponse>(key, response);
    }

    private static IdentifiableMessage<Throwable> deleteMessageCreateThrowable(BatchResultErrorEntry failedEntry) {
        String key = failedEntry.id();
        AwsErrorDetails errorDetailsBuilder = AwsErrorDetails.builder().errorCode(failedEntry.code()).errorMessage(failedEntry.message()).build();
        AwsServiceException response = SqsException.builder().awsErrorDetails(errorDetailsBuilder).build();
        return new IdentifiableMessage<AwsServiceException>(key, response);
    }

    @Override
    protected CompletableFuture<DeleteMessageBatchResponse> batchAndSend(List<IdentifiableMessage<DeleteMessageRequest>> identifiedRequests, String batchKey) {
        DeleteMessageBatchRequest batchRequest = DeleteMessageBatchManager.createDeleteMessageBatchRequest(identifiedRequests, batchKey);
        return this.sqsAsyncClient.deleteMessageBatch(batchRequest);
    }

    @Override
    protected String getBatchKey(DeleteMessageRequest request) {
        return request.overrideConfiguration().map(overrideConfig -> request.queueUrl() + overrideConfig.hashCode()).orElse(request.queueUrl());
    }

    @Override
    protected List<Either<IdentifiableMessage<DeleteMessageResponse>, IdentifiableMessage<Throwable>>> mapBatchResponse(DeleteMessageBatchResponse batchResponse) {
        ArrayList<Either<IdentifiableMessage<DeleteMessageResponse>, IdentifiableMessage<Throwable>>> mappedResponses = new ArrayList<Either<IdentifiableMessage<DeleteMessageResponse>, IdentifiableMessage<Throwable>>>();
        batchResponse.successful().forEach(batchResponseEntry -> {
            IdentifiableMessage<DeleteMessageResponse> response = DeleteMessageBatchManager.createDeleteMessageResponse(batchResponseEntry, batchResponse);
            mappedResponses.add(Either.left(response));
        });
        batchResponse.failed().forEach(batchResponseEntry -> {
            IdentifiableMessage<Throwable> response = DeleteMessageBatchManager.deleteMessageCreateThrowable(batchResponseEntry);
            mappedResponses.add(Either.right(response));
        });
        return mappedResponses;
    }
}

