/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMessageMoveTaskResponse extends SqsResponse implements
        ToCopyableBuilder<StartMessageMoveTaskResponse.Builder, StartMessageMoveTaskResponse> {
    private static final SdkField<String> TASK_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskHandle").getter(getter(StartMessageMoveTaskResponse::taskHandle))
            .setter(setter(Builder::taskHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskHandle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_HANDLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TaskHandle", TASK_HANDLE_FIELD);
                }
            });

    private final String taskHandle;

    private StartMessageMoveTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskHandle = builder.taskHandle;
    }

    /**
     * <p>
     * An identifier associated with a message movement task. You can use this identifier to cancel a specified message
     * movement task using the <code>CancelMessageMoveTask</code> action.
     * </p>
     * 
     * @return An identifier associated with a message movement task. You can use this identifier to cancel a specified
     *         message movement task using the <code>CancelMessageMoveTask</code> action.
     */
    public final String taskHandle() {
        return taskHandle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskHandle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMessageMoveTaskResponse)) {
            return false;
        }
        StartMessageMoveTaskResponse other = (StartMessageMoveTaskResponse) obj;
        return Objects.equals(taskHandle(), other.taskHandle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMessageMoveTaskResponse").add("TaskHandle", taskHandle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskHandle":
            return Optional.ofNullable(clazz.cast(taskHandle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartMessageMoveTaskResponse, T> g) {
        return obj -> g.apply((StartMessageMoveTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMessageMoveTaskResponse> {
        /**
         * <p>
         * An identifier associated with a message movement task. You can use this identifier to cancel a specified
         * message movement task using the <code>CancelMessageMoveTask</code> action.
         * </p>
         * 
         * @param taskHandle
         *        An identifier associated with a message movement task. You can use this identifier to cancel a
         *        specified message movement task using the <code>CancelMessageMoveTask</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskHandle(String taskHandle);
    }

    static final class BuilderImpl extends SqsResponse.BuilderImpl implements Builder {
        private String taskHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMessageMoveTaskResponse model) {
            super(model);
            taskHandle(model.taskHandle);
        }

        public final String getTaskHandle() {
            return taskHandle;
        }

        public final void setTaskHandle(String taskHandle) {
            this.taskHandle = taskHandle;
        }

        @Override
        public final Builder taskHandle(String taskHandle) {
            this.taskHandle = taskHandle;
            return this;
        }

        @Override
        public StartMessageMoveTaskResponse build() {
            return new StartMessageMoveTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
