/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueueAttributesRequest extends SqsRequest implements
        ToCopyableBuilder<GetQueueAttributesRequest.Builder, GetQueueAttributesRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueUrl").getter(getter(GetQueueAttributesRequest::queueUrl)).setter(setter(Builder::queueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(GetQueueAttributesRequest::attributeNamesAsStrings))
            .setter(setter(Builder::attributeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD,
            ATTRIBUTE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueueUrl", QUEUE_URL_FIELD);
                    put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
                }
            });

    private final String queueUrl;

    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue whose attribute information is retrieved.
     * </p>
     * <p>
     * Queue URLs and names are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
     *         <p>
     *         Queue URLs and names are case-sensitive.
     */
    public final String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of attributes for which to retrieve information.
     * </p>
     * <p>
     * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter, the
     * request returns empty results.
     * </p>
     * <note>
     * <p>
     * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
     * structure your code so that it can handle new attributes gracefully.
     * </p>
     * </note>
     * <p>
     * The following attributes are supported:
     * </p>
     * <important>
     * <p>
     * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
     * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after the
     * producers stop sending messages. This period is required for the queue metadata to reach eventual consistency.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>All</code> – Returns all values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
     * from the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue that
     * are delayed and not available for reading immediately. This can happen when the queue is configured as a delay
     * queue or when a message has been sent with a delay parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
     * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet been
     * deleted or have not yet reached the end of their visibility window.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
     * rejects it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
     * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to
     * propagate throughout the Amazon SQS system. Changes made to the <code>MessageRetentionPeriod</code> attribute can
     * take up to 15 minutes and will impact existing messages in the queue potentially causing them to be expired and
     * deleted if the <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy</code> – Returns the policy of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
     * <code>ReceiveMessage</code> action waits for a message to arrive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
     * visibility timeout, see <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     * >dead-letter queues:</a>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality of
     * the source queue as a JSON object. The parameters are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS
     * moves messages after the value of <code>maxReceiveCount</code> is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being moved
     * to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
     * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
     * queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
     * queue as the dead-letter queue. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
     * specify this queue as the dead-letter queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue
     * as the dead-letter queue.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this queue
     * as the dead-letter queue and redrive messages. You can specify this parameter only when the
     * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue
     * ARNs. To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code>
     * parameter to <code>allowAll</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard
     * queue must also be a standard queue.
     * </p>
     * </note>
     * <p>
     * The following attributes apply only to <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     * >server-side-encryption</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
     * Amazon SQS or a custom CMK. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     * >Key Terms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
     * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
     * >How Does the Data Key Reuse Period Work?</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption using
     * SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example, <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
     * >SSE-KMS</a> or <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
     * >SSE-SQS</a>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     * (first-in-first-out) queues</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
     * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * To determine whether a queue is <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you
     * can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the queue.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
     * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high
     * throughput for FIFO queues</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or queue
     * level. Valid values are <code>messageGroup</code> and <code>queue</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire queue
     * or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
     * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
     * <code>messageGroup</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable high throughput for FIFO queues, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set these attributes to anything other than the values shown for enabling high throughput, normal
     * throughput is in effect and deduplication occurs as specified.
     * </p>
     * <p>
     * For information on throughput quotas, see <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
     * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes for which to retrieve information.</p>
     *         <p>
     *         The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
     *         parameter, the request returns empty results.
     *         </p>
     *         <note>
     *         <p>
     *         In the future, new attributes might be added. If you write code that calls this action, we recommend that
     *         you structure your code so that it can handle new attributes gracefully.
     *         </p>
     *         </note>
     *         <p>
     *         The following attributes are supported:
     *         </p>
     *         <important>
     *         <p>
     *         The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>,
     *         and <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute
     *         after the producers stop sending messages. This period is required for the queue metadata to reach
     *         eventual consistency.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>All</code> – Returns all values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
     *         retrieval from the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
     *         that are delayed and not available for reading immediately. This can happen when the queue is configured
     *         as a delay queue or when a message has been sent with a delay parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are
     *         in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not
     *         yet been deleted or have not yet reached the end of their visibility window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon
     *         SQS rejects it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
     *         retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most of
     *         the attributes to propagate throughout the Amazon SQS system. Changes made to the
     *         <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages
     *         in the queue potentially causing them to be expired and deleted if the
     *         <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy</code> – Returns the policy of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
     *         <code>ReceiveMessage</code> action waits for a message to arrive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about
     *         the visibility timeout, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     *         >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     *         >dead-letter queues:</a>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
     *         functionality of the source queue as a JSON object. The parameters are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
     *         Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
     *         being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
     *         exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
     *         dead-letter-queue.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
     *         dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
     *         object. The parameters are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>redrivePermission</code> – The permission type that defines which source queues can specify the
     *         current queue as the dead-letter queue. Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
     *         Region can specify this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
     *         this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
     *         this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
     *         <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
     *         queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
     *         <code>redrivePermission</code> parameter to <code>allowAll</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
     *         standard queue must also be a standard queue.
     *         </p>
     *         </note>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     *         >server-side-encryption</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK)
     *         for Amazon SQS or a custom CMK. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     *         >Key Terms</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS
     *         can reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
     *         >How Does the Data Key Reuse Period Work?</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
     *         encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue
     *         (for example, <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
     *         >SSE-KMS</a> or <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
     *         >SSE-SQS</a>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     *         (first-in-first-out) queues</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
     *         >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         To determine whether a queue is <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
     *         >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
     *         queue. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
     *         >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
     *         >high throughput for FIFO queues</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
     *         queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
     *         entire queue or per message group. Valid values are <code>perQueue</code> and
     *         <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the value
     *         for <code>DeduplicationScope</code> is <code>messageGroup</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable high throughput for FIFO queues, do the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set these attributes to anything other than the values shown for enabling high throughput, normal
     *         throughput is in effect and deduplication occurs as specified.
     *         </p>
     *         <p>
     *         For information on throughput quotas, see <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
     *         >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public final List<QueueAttributeName> attributeNames() {
        return AttributeNameListCopier.copyStringToEnum(attributeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes for which to retrieve information.
     * </p>
     * <p>
     * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter, the
     * request returns empty results.
     * </p>
     * <note>
     * <p>
     * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
     * structure your code so that it can handle new attributes gracefully.
     * </p>
     * </note>
     * <p>
     * The following attributes are supported:
     * </p>
     * <important>
     * <p>
     * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
     * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after the
     * producers stop sending messages. This period is required for the queue metadata to reach eventual consistency.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>All</code> – Returns all values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
     * from the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue that
     * are delayed and not available for reading immediately. This can happen when the queue is configured as a delay
     * queue or when a message has been sent with a delay parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
     * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet been
     * deleted or have not yet reached the end of their visibility window.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
     * rejects it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
     * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to
     * propagate throughout the Amazon SQS system. Changes made to the <code>MessageRetentionPeriod</code> attribute can
     * take up to 15 minutes and will impact existing messages in the queue potentially causing them to be expired and
     * deleted if the <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy</code> – Returns the policy of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
     * <code>ReceiveMessage</code> action waits for a message to arrive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
     * visibility timeout, see <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     * >dead-letter queues:</a>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality of
     * the source queue as a JSON object. The parameters are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS
     * moves messages after the value of <code>maxReceiveCount</code> is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being moved
     * to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
     * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
     * queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters
     * are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
     * queue as the dead-letter queue. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
     * specify this queue as the dead-letter queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue
     * as the dead-letter queue.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this queue
     * as the dead-letter queue and redrive messages. You can specify this parameter only when the
     * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue
     * ARNs. To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code>
     * parameter to <code>allowAll</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard
     * queue must also be a standard queue.
     * </p>
     * </note>
     * <p>
     * The following attributes apply only to <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     * >server-side-encryption</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
     * Amazon SQS or a custom CMK. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     * >Key Terms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
     * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
     * >How Does the Data Key Reuse Period Work?</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption using
     * SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example, <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
     * >SSE-KMS</a> or <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
     * >SSE-SQS</a>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     * (first-in-first-out) queues</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
     * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * To determine whether a queue is <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you
     * can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the queue.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
     * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes apply only to <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high
     * throughput for FIFO queues</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or queue
     * level. Valid values are <code>messageGroup</code> and <code>queue</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire queue
     * or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
     * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
     * <code>messageGroup</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable high throughput for FIFO queues, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set these attributes to anything other than the values shown for enabling high throughput, normal
     * throughput is in effect and deduplication occurs as specified.
     * </p>
     * <p>
     * For information on throughput quotas, see <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
     * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes for which to retrieve information.</p>
     *         <p>
     *         The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
     *         parameter, the request returns empty results.
     *         </p>
     *         <note>
     *         <p>
     *         In the future, new attributes might be added. If you write code that calls this action, we recommend that
     *         you structure your code so that it can handle new attributes gracefully.
     *         </p>
     *         </note>
     *         <p>
     *         The following attributes are supported:
     *         </p>
     *         <important>
     *         <p>
     *         The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>,
     *         and <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute
     *         after the producers stop sending messages. This period is required for the queue metadata to reach
     *         eventual consistency.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>All</code> – Returns all values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
     *         retrieval from the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
     *         that are delayed and not available for reading immediately. This can happen when the queue is configured
     *         as a delay queue or when a message has been sent with a delay parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are
     *         in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not
     *         yet been deleted or have not yet reached the end of their visibility window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon
     *         SQS rejects it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
     *         retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most of
     *         the attributes to propagate throughout the Amazon SQS system. Changes made to the
     *         <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages
     *         in the queue potentially causing them to be expired and deleted if the
     *         <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy</code> – Returns the policy of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
     *         <code>ReceiveMessage</code> action waits for a message to arrive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about
     *         the visibility timeout, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     *         >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
     *         >dead-letter queues:</a>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
     *         functionality of the source queue as a JSON object. The parameters are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
     *         Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
     *         being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
     *         exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
     *         dead-letter-queue.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
     *         dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
     *         object. The parameters are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>redrivePermission</code> – The permission type that defines which source queues can specify the
     *         current queue as the dead-letter queue. Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
     *         Region can specify this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
     *         this queue as the dead-letter queue.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
     *         this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
     *         <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
     *         queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
     *         <code>redrivePermission</code> parameter to <code>allowAll</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
     *         standard queue must also be a standard queue.
     *         </p>
     *         </note>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
     *         >server-side-encryption</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK)
     *         for Amazon SQS or a custom CMK. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
     *         >Key Terms</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS
     *         can reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
     *         >How Does the Data Key Reuse Period Work?</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
     *         encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue
     *         (for example, <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
     *         >SSE-KMS</a> or <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
     *         >SSE-SQS</a>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
     *         (first-in-first-out) queues</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
     *         >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         To determine whether a queue is <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
     *         >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
     *         queue. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
     *         >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes apply only to <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
     *         >high throughput for FIFO queues</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
     *         queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
     *         entire queue or per message group. Valid values are <code>perQueue</code> and
     *         <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the value
     *         for <code>DeduplicationScope</code> is <code>messageGroup</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable high throughput for FIFO queues, do the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set these attributes to anything other than the values shown for enabling high throughput, normal
     *         throughput is in effect and deduplication occurs as specified.
     *         </p>
     *         <p>
     *         For information on throughput quotas, see <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
     *         >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public final List<String> attributeNamesAsStrings() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && hasAttributeNames() == other.hasAttributeNames()
                && Objects.equals(attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueueAttributesRequest").add("QueueUrl", queueUrl())
                .add("AttributeNames", hasAttributeNames() ? attributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.ofNullable(clazz.cast(queueUrl()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueueAttributesRequest, T> g) {
        return obj -> g.apply((GetQueueAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetQueueAttributesRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue whose attribute information is retrieved.
         * </p>
         * <p>
         * Queue URLs and names are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
         *        <p>
         *        Queue URLs and names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <p>
         * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter,
         * the request returns empty results.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <important>
         * <p>
         * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
         * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after
         * the producers stop sending messages. This period is required for the queue metadata to reach eventual
         * consistency.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> – Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
         * from the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
         * that are delayed and not available for reading immediately. This can happen when the queue is configured as a
         * delay queue or when a message has been sent with a delay parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
         * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet
         * been deleted or have not yet reached the end of their visibility window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
         * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the
         * attributes to propagate throughout the Amazon SQS system. Changes made to the
         * <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages in
         * the queue potentially causing them to be expired and deleted if the <code>MessageRetentionPeriod</code> is
         * reduced below the age of existing messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> – Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         * >dead-letter queues:</a>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
         * of the source queue as a JSON object. The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon
         * SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
         * moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
         * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         * dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         * The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
         * queue as the dead-letter queue. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region
         * can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this
         * queue as the dead-letter queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this
         * queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
         * queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         * <code>redrivePermission</code> parameter to <code>allowAll</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         * standard queue must also be a standard queue.
         * </p>
         * </note>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
         * Amazon SQS or a custom CMK. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         * >How Does the Data Key Reuse Period Work?</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption
         * using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example,
         * <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         * >SSE-KMS</a> or <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         * >SSE-SQS</a>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         * >high throughput for FIFO queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
         * queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire
         * queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
         * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
         * <code>messageGroup</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable high throughput for FIFO queues, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set these attributes to anything other than the values shown for enabling high throughput, normal
         * throughput is in effect and deduplication occurs as specified.
         * </p>
         * <p>
         * For information on throughput quotas, see <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
         * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p>
         *        <p>
         *        The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
         *        parameter, the request returns empty results.
         *        </p>
         *        <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <important>
         *        <p>
         *        The <code>ApproximateNumberOfMessagesDelayed</code>,
         *        <code>ApproximateNumberOfMessagesNotVisible</code>, and <code>ApproximateNumberOfMessages</code>
         *        metrics may not achieve consistency until at least 1 minute after the producers stop sending messages.
         *        This period is required for the queue metadata to reach eventual consistency.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> – Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
         *        retrieval from the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the
         *        queue that are delayed and not available for reading immediately. This can happen when the queue is
         *        configured as a delay queue or when a message has been sent with a delay parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that
         *        are in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but
         *        have not yet been deleted or have not yet reached the end of their visibility window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most
         *        of the attributes to propagate throughout the Amazon SQS system. Changes made to the
         *        <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing
         *        messages in the queue potentially causing them to be expired and deleted if the
         *        <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> – Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >dead-letter queues:</a>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
         *        functionality of the source queue as a JSON object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
         *        Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
         *        being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
         *        exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
         *        dead-letter-queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         *        dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
         *        object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>redrivePermission</code> – The permission type that defines which source queues can specify the
         *        current queue as the dead-letter queue. Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
         *        Region can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
         *        this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
         *        this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         *        <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10
         *        source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         *        <code>redrivePermission</code> parameter to <code>allowAll</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         *        standard queue must also be a standard queue.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key
         *        (CMK) for Amazon SQS or a custom CMK. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling KMS again. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         *        >How Does the Data Key Reuse Period Work?</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
         *        encryption using SQS owned encryption keys. Only one server-side encryption option is supported per
         *        queue (for example, <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         *        >SSE-KMS</a> or <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         *        >SSE-SQS</a>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         *        >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         *        >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         *        >high throughput for FIFO queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group
         *        or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
         *        entire queue or per message group. Valid values are <code>perQueue</code> and
         *        <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the
         *        value for <code>DeduplicationScope</code> is <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable high throughput for FIFO queues, do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set these attributes to anything other than the values shown for enabling high throughput,
         *        normal throughput is in effect and deduplication occurs as specified.
         *        </p>
         *        <p>
         *        For information on throughput quotas, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
         *        >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(Collection<String> attributeNames);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <p>
         * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter,
         * the request returns empty results.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <important>
         * <p>
         * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
         * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after
         * the producers stop sending messages. This period is required for the queue metadata to reach eventual
         * consistency.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> – Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
         * from the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
         * that are delayed and not available for reading immediately. This can happen when the queue is configured as a
         * delay queue or when a message has been sent with a delay parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
         * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet
         * been deleted or have not yet reached the end of their visibility window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
         * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the
         * attributes to propagate throughout the Amazon SQS system. Changes made to the
         * <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages in
         * the queue potentially causing them to be expired and deleted if the <code>MessageRetentionPeriod</code> is
         * reduced below the age of existing messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> – Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         * >dead-letter queues:</a>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
         * of the source queue as a JSON object. The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon
         * SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
         * moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
         * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         * dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         * The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
         * queue as the dead-letter queue. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region
         * can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this
         * queue as the dead-letter queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this
         * queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
         * queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         * <code>redrivePermission</code> parameter to <code>allowAll</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         * standard queue must also be a standard queue.
         * </p>
         * </note>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
         * Amazon SQS or a custom CMK. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         * >How Does the Data Key Reuse Period Work?</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption
         * using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example,
         * <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         * >SSE-KMS</a> or <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         * >SSE-SQS</a>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         * >high throughput for FIFO queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
         * queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire
         * queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
         * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
         * <code>messageGroup</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable high throughput for FIFO queues, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set these attributes to anything other than the values shown for enabling high throughput, normal
         * throughput is in effect and deduplication occurs as specified.
         * </p>
         * <p>
         * For information on throughput quotas, see <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
         * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p>
         *        <p>
         *        The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
         *        parameter, the request returns empty results.
         *        </p>
         *        <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <important>
         *        <p>
         *        The <code>ApproximateNumberOfMessagesDelayed</code>,
         *        <code>ApproximateNumberOfMessagesNotVisible</code>, and <code>ApproximateNumberOfMessages</code>
         *        metrics may not achieve consistency until at least 1 minute after the producers stop sending messages.
         *        This period is required for the queue metadata to reach eventual consistency.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> – Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
         *        retrieval from the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the
         *        queue that are delayed and not available for reading immediately. This can happen when the queue is
         *        configured as a delay queue or when a message has been sent with a delay parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that
         *        are in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but
         *        have not yet been deleted or have not yet reached the end of their visibility window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most
         *        of the attributes to propagate throughout the Amazon SQS system. Changes made to the
         *        <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing
         *        messages in the queue potentially causing them to be expired and deleted if the
         *        <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> – Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >dead-letter queues:</a>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
         *        functionality of the source queue as a JSON object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
         *        Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
         *        being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
         *        exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
         *        dead-letter-queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         *        dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
         *        object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>redrivePermission</code> – The permission type that defines which source queues can specify the
         *        current queue as the dead-letter queue. Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
         *        Region can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
         *        this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
         *        this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         *        <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10
         *        source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         *        <code>redrivePermission</code> parameter to <code>allowAll</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         *        standard queue must also be a standard queue.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key
         *        (CMK) for Amazon SQS or a custom CMK. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling KMS again. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         *        >How Does the Data Key Reuse Period Work?</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
         *        encryption using SQS owned encryption keys. Only one server-side encryption option is supported per
         *        queue (for example, <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         *        >SSE-KMS</a> or <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         *        >SSE-SQS</a>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         *        >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         *        >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         *        >high throughput for FIFO queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group
         *        or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
         *        entire queue or per message group. Valid values are <code>perQueue</code> and
         *        <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the
         *        value for <code>DeduplicationScope</code> is <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable high throughput for FIFO queues, do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set these attributes to anything other than the values shown for enabling high throughput,
         *        normal throughput is in effect and deduplication occurs as specified.
         *        </p>
         *        <p>
         *        For information on throughput quotas, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
         *        >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(String... attributeNames);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <p>
         * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter,
         * the request returns empty results.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <important>
         * <p>
         * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
         * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after
         * the producers stop sending messages. This period is required for the queue metadata to reach eventual
         * consistency.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> – Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
         * from the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
         * that are delayed and not available for reading immediately. This can happen when the queue is configured as a
         * delay queue or when a message has been sent with a delay parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
         * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet
         * been deleted or have not yet reached the end of their visibility window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
         * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the
         * attributes to propagate throughout the Amazon SQS system. Changes made to the
         * <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages in
         * the queue potentially causing them to be expired and deleted if the <code>MessageRetentionPeriod</code> is
         * reduced below the age of existing messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> – Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         * >dead-letter queues:</a>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
         * of the source queue as a JSON object. The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon
         * SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
         * moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
         * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         * dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         * The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
         * queue as the dead-letter queue. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region
         * can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this
         * queue as the dead-letter queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this
         * queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
         * queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         * <code>redrivePermission</code> parameter to <code>allowAll</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         * standard queue must also be a standard queue.
         * </p>
         * </note>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
         * Amazon SQS or a custom CMK. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         * >How Does the Data Key Reuse Period Work?</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption
         * using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example,
         * <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         * >SSE-KMS</a> or <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         * >SSE-SQS</a>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         * >high throughput for FIFO queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
         * queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire
         * queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
         * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
         * <code>messageGroup</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable high throughput for FIFO queues, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set these attributes to anything other than the values shown for enabling high throughput, normal
         * throughput is in effect and deduplication occurs as specified.
         * </p>
         * <p>
         * For information on throughput quotas, see <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
         * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p>
         *        <p>
         *        The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
         *        parameter, the request returns empty results.
         *        </p>
         *        <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <important>
         *        <p>
         *        The <code>ApproximateNumberOfMessagesDelayed</code>,
         *        <code>ApproximateNumberOfMessagesNotVisible</code>, and <code>ApproximateNumberOfMessages</code>
         *        metrics may not achieve consistency until at least 1 minute after the producers stop sending messages.
         *        This period is required for the queue metadata to reach eventual consistency.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> – Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
         *        retrieval from the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the
         *        queue that are delayed and not available for reading immediately. This can happen when the queue is
         *        configured as a delay queue or when a message has been sent with a delay parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that
         *        are in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but
         *        have not yet been deleted or have not yet reached the end of their visibility window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most
         *        of the attributes to propagate throughout the Amazon SQS system. Changes made to the
         *        <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing
         *        messages in the queue potentially causing them to be expired and deleted if the
         *        <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> – Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >dead-letter queues:</a>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
         *        functionality of the source queue as a JSON object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
         *        Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
         *        being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
         *        exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
         *        dead-letter-queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         *        dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
         *        object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>redrivePermission</code> – The permission type that defines which source queues can specify the
         *        current queue as the dead-letter queue. Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
         *        Region can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
         *        this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
         *        this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         *        <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10
         *        source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         *        <code>redrivePermission</code> parameter to <code>allowAll</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         *        standard queue must also be a standard queue.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key
         *        (CMK) for Amazon SQS or a custom CMK. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling KMS again. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         *        >How Does the Data Key Reuse Period Work?</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
         *        encryption using SQS owned encryption keys. Only one server-side encryption option is supported per
         *        queue (for example, <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         *        >SSE-KMS</a> or <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         *        >SSE-SQS</a>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         *        >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         *        >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         *        >high throughput for FIFO queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group
         *        or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
         *        entire queue or per message group. Valid values are <code>perQueue</code> and
         *        <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the
         *        value for <code>DeduplicationScope</code> is <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable high throughput for FIFO queues, do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set these attributes to anything other than the values shown for enabling high throughput,
         *        normal throughput is in effect and deduplication occurs as specified.
         *        </p>
         *        <p>
         *        For information on throughput quotas, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
         *        >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<QueueAttributeName> attributeNames);

        /**
         * <p>
         * A list of attributes for which to retrieve information.
         * </p>
         * <p>
         * The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this parameter,
         * the request returns empty results.
         * </p>
         * <note>
         * <p>
         * In the future, new attributes might be added. If you write code that calls this action, we recommend that you
         * structure your code so that it can handle new attributes gracefully.
         * </p>
         * </note>
         * <p>
         * The following attributes are supported:
         * </p>
         * <important>
         * <p>
         * The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>, and
         * <code>ApproximateNumberOfMessages</code> metrics may not achieve consistency until at least 1 minute after
         * the producers stop sending messages. This period is required for the queue metadata to reach eventual
         * consistency.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> – Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for retrieval
         * from the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the queue
         * that are delayed and not available for reading immediately. This can happen when the queue is configured as a
         * delay queue or when a message has been sent with a delay parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that are in
         * flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but have not yet
         * been deleted or have not yet reached the end of their visibility window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before Amazon SQS
         * rejects it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS retains a
         * message. When you change a queue's attributes, the change can take up to 60 seconds for most of the
         * attributes to propagate throughout the Amazon SQS system. Changes made to the
         * <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing messages in
         * the queue potentially causing them to be expired and deleted if the <code>MessageRetentionPeriod</code> is
         * reduced below the age of existing messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code> – Returns the policy of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         * <code>ReceiveMessage</code> action waits for a message to arrive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the
         * visibility timeout, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         * >dead-letter queues:</a>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
         * of the source queue as a JSON object. The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon
         * SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
         * moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message exceeds the
         * <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         * dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         * The parameters are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>redrivePermission</code> – The permission type that defines which source queues can specify the current
         * queue as the dead-letter queue. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region
         * can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify this
         * queue as the dead-letter queue.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify this
         * queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         * <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source
         * queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         * <code>redrivePermission</code> parameter to <code>allowAll</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         * standard queue must also be a standard queue.
         * </p>
         * </note>
         * <p>
         * The following attributes apply only to <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         * >server-side-encryption</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for
         * Amazon SQS or a custom CMK. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         * >Key Terms</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can
         * reuse a data key to encrypt or decrypt messages before calling KMS again. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         * >How Does the Data Key Reuse Period Work?</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS encryption
         * using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example,
         * <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         * >SSE-KMS</a> or <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         * >SSE-SQS</a>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO
         * (first-in-first-out) queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         * >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * To determine whether a queue is <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>,
         * you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the
         * queue. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         * >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes apply only to <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         * >high throughput for FIFO queues</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group or
         * queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the entire
         * queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>. The
         * <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is
         * <code>messageGroup</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable high throughput for FIFO queues, do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set these attributes to anything other than the values shown for enabling high throughput, normal
         * throughput is in effect and deduplication occurs as specified.
         * </p>
         * <p>
         * For information on throughput quotas, see <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas
         * related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes for which to retrieve information.</p>
         *        <p>
         *        The <code>AttributeNames</code> parameter is optional, but if you don't specify values for this
         *        parameter, the request returns empty results.
         *        </p>
         *        <note>
         *        <p>
         *        In the future, new attributes might be added. If you write code that calls this action, we recommend
         *        that you structure your code so that it can handle new attributes gracefully.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes are supported:
         *        </p>
         *        <important>
         *        <p>
         *        The <code>ApproximateNumberOfMessagesDelayed</code>,
         *        <code>ApproximateNumberOfMessagesNotVisible</code>, and <code>ApproximateNumberOfMessages</code>
         *        metrics may not achieve consistency until at least 1 minute after the producers stop sending messages.
         *        This period is required for the queue metadata to reach eventual consistency.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> – Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code> – Returns the approximate number of messages available for
         *        retrieval from the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number of messages in the
         *        queue that are delayed and not available for reading immediately. This can happen when the queue is
         *        configured as a delay queue or when a message has been sent with a delay parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate number of messages that
         *        are in flight. Messages are considered to be <i>in flight</i> if they have been sent to a client but
         *        have not yet been deleted or have not yet reached the end of their visibility window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code> – Returns the time when the queue was created in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code> – Returns the default delay on the queue in seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code> – Returns the time when the queue was last changed in seconds (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message can contain before
         *        Amazon SQS rejects it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds, for which Amazon SQS
         *        retains a message. When you change a queue's attributes, the change can take up to 60 seconds for most
         *        of the attributes to propagate throughout the Amazon SQS system. Changes made to the
         *        <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes and will impact existing
         *        messages in the queue potentially causing them to be expired and deleted if the
         *        <code>MessageRetentionPeriod</code> is reduced below the age of existing messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code> – Returns the policy of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in seconds, for which the
         *        <code>ReceiveMessage</code> action waits for a message to arrive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information
         *        about the visibility timeout, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html"
         *        >dead-letter queues:</a>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue
         *        functionality of the source queue as a JSON object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to which
         *        Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before
         *        being moved to the dead-letter queue. Default: 10. When the <code>ReceiveCount</code> for a message
         *        exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the
         *        dead-letter-queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the
         *        dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON
         *        object. The parameters are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>redrivePermission</code> – The permission type that defines which source queues can specify the
         *        current queue as the dead-letter queue. Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same
         *        Region can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>denyAll</code> – No source queues can specify this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
         *        this queue as the dead-letter queue.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
         *        this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
         *        <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10
         *        source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the
         *        <code>redrivePermission</code> parameter to <code>allowAll</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a
         *        standard queue must also be a standard queue.
         *        </p>
         *        </note>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html"
         *        >server-side-encryption</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key
         *        (CMK) for Amazon SQS or a custom CMK. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms"
         *        >Key Terms</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon
         *        SQS can reuse a data key to encrypt or decrypt messages before calling KMS again. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work"
         *        >How Does the Data Key Reuse Period Work?</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SqsManagedSseEnabled</code> – Returns information about whether the queue is using SSE-SQS
         *        encryption using SQS owned encryption keys. Only one server-side encryption option is supported per
         *        queue (for example, <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html"
         *        >SSE-KMS</a> or <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html"
         *        >SSE-SQS</a>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO (first-in-first-out) queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html"
         *        >FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        To determine whether a queue is <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html"
         *        >FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for
         *        the queue. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"
         *        >Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes apply only to <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html"
         *        >high throughput for FIFO queues</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the message group
         *        or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput quota applies to the
         *        entire queue or per message group. Valid values are <code>perQueue</code> and
         *        <code>perMessageGroupId</code>. The <code>perMessageGroupId</code> value is allowed only when the
         *        value for <code>DeduplicationScope</code> is <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable high throughput for FIFO queues, do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set <code>DeduplicationScope</code> to <code>messageGroup</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set these attributes to anything other than the values shown for enabling high throughput,
         *        normal throughput is in effect and deduplication occurs as specified.
         *        </p>
         *        <p>
         *        For information on throughput quotas, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html"
         *        >Quotas related to messages</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(QueueAttributeName... attributeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            attributeNamesWithStrings(model.attributeNames);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String... attributeNames) {
            attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<QueueAttributeName> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
