/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntryListCopier;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeMessageVisibilityBatchResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, ChangeMessageVisibilityBatchResponse> {
    private static final SdkField<List<ChangeMessageVisibilityBatchResultEntry>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(ChangeMessageVisibilityBatchResponse.getter(ChangeMessageVisibilityBatchResponse::successful)).setter(ChangeMessageVisibilityBatchResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeMessageVisibilityBatchResultEntry").build(), ListTrait.builder().memberLocationName("ChangeMessageVisibilityBatchResultEntry").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeMessageVisibilityBatchResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeMessageVisibilityBatchResultEntry").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<BatchResultErrorEntry>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(ChangeMessageVisibilityBatchResponse.getter(ChangeMessageVisibilityBatchResponse::failed)).setter(ChangeMessageVisibilityBatchResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchResultErrorEntry").build(), ListTrait.builder().memberLocationName("BatchResultErrorEntry").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchResultErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchResultErrorEntry").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD));
    private final List<ChangeMessageVisibilityBatchResultEntry> successful;
    private final List<BatchResultErrorEntry> failed;

    private ChangeMessageVisibilityBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<ChangeMessageVisibilityBatchResultEntry> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchResultErrorEntry> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchResponse)) {
            return false;
        }
        ChangeMessageVisibilityBatchResponse other = (ChangeMessageVisibilityBatchResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeMessageVisibilityBatchResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeMessageVisibilityBatchResponse, T> g) {
        return obj -> g.apply((ChangeMessageVisibilityBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private List<ChangeMessageVisibilityBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final List<ChangeMessageVisibilityBatchResultEntry.Builder> getSuccessful() {
            List<ChangeMessageVisibilityBatchResultEntry.Builder> result = ChangeMessageVisibilityBatchResultEntryListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<ChangeMessageVisibilityBatchResultEntry.BuilderImpl> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(ChangeMessageVisibilityBatchResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<ChangeMessageVisibilityBatchResultEntry.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (ChangeMessageVisibilityBatchResultEntry)((ChangeMessageVisibilityBatchResultEntry.Builder)ChangeMessageVisibilityBatchResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchResultErrorEntry.Builder> getFailed() {
            List<BatchResultErrorEntry.Builder> result = BatchResultErrorEntryListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchResultErrorEntry)((BatchResultErrorEntry.Builder)BatchResultErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChangeMessageVisibilityBatchResponse build() {
            return new ChangeMessageVisibilityBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeMessageVisibilityBatchResponse> {
        public Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> var1);

        public Builder successful(ChangeMessageVisibilityBatchResultEntry ... var1);

        public Builder successful(Consumer<ChangeMessageVisibilityBatchResultEntry.Builder> ... var1);

        public Builder failed(Collection<BatchResultErrorEntry> var1);

        public Builder failed(BatchResultErrorEntry ... var1);

        public Builder failed(Consumer<BatchResultErrorEntry.Builder> ... var1);
    }
}

