/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sns.model.BatchResultErrorEntryListCopier;
import software.amazon.awssdk.services.sns.model.PublishBatchResultEntry;
import software.amazon.awssdk.services.sns.model.PublishBatchResultEntryListCopier;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishBatchResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, PublishBatchResponse> {
    private static final SdkField<List<PublishBatchResultEntry>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(PublishBatchResponse.getter(PublishBatchResponse::successful)).setter(PublishBatchResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublishBatchResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchResultErrorEntry>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(PublishBatchResponse.getter(PublishBatchResponse::failed)).setter(PublishBatchResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchResultErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Successful", SUCCESSFUL_FIELD);
            this.put("Failed", FAILED_FIELD);
        }
    });
    private final List<PublishBatchResultEntry> successful;
    private final List<BatchResultErrorEntry> failed;

    private PublishBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<PublishBatchResultEntry> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchResultErrorEntry> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishBatchResponse)) {
            return false;
        }
        PublishBatchResponse other = (PublishBatchResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"PublishBatchResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishBatchResponse, T> g) {
        return obj -> g.apply((PublishBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<PublishBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishBatchResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final List<PublishBatchResultEntry.Builder> getSuccessful() {
            List<PublishBatchResultEntry.Builder> result = PublishBatchResultEntryListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<PublishBatchResultEntry.BuilderImpl> successful) {
            this.successful = PublishBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<PublishBatchResultEntry> successful) {
            this.successful = PublishBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(PublishBatchResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<PublishBatchResultEntry.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (PublishBatchResultEntry)((PublishBatchResultEntry.Builder)PublishBatchResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchResultErrorEntry.Builder> getFailed() {
            List<BatchResultErrorEntry.Builder> result = BatchResultErrorEntryListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchResultErrorEntry)((BatchResultErrorEntry.Builder)BatchResultErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PublishBatchResponse build() {
            return new PublishBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishBatchResponse> {
        public Builder successful(Collection<PublishBatchResultEntry> var1);

        public Builder successful(PublishBatchResultEntry ... var1);

        public Builder successful(Consumer<PublishBatchResultEntry.Builder> ... var1);

        public Builder failed(Collection<BatchResultErrorEntry> var1);

        public Builder failed(BatchResultErrorEntry ... var1);

        public Builder failed(Consumer<BatchResultErrorEntry.Builder> ... var1);
    }
}

