/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetSubscriptionAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSubscriptionAttributesRequest extends SnsRequest implements
        ToCopyableBuilder<SetSubscriptionAttributesRequest.Builder, SetSubscriptionAttributesRequest> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionArn").getter(getter(SetSubscriptionAttributesRequest::subscriptionArn))
            .setter(setter(Builder::subscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(SetSubscriptionAttributesRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeValue").getter(getter(SetSubscriptionAttributesRequest::attributeValue))
            .setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD,
            ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD));

    private final String subscriptionArn;

    private final String attributeName;

    private final String attributeValue;

    private SetSubscriptionAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The ARN of the subscription to modify.
     * </p>
     * 
     * @return The ARN of the subscription to modify.
     */
    public final String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * A map of attributes with their corresponding values.
     * </p>
     * <p>
     * The following lists the names, descriptions, and values of the special request parameters that this action uses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S
     * endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of messages,
     * rather than receiving every message published to the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to Amazon SQS or
     * HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise
     * created for Amazon SNS metadata.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter
     * queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is
     * unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes
     * unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Permission to write to the Kinesis Data Firehose delivery stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SNS listed as a trusted entity
     * </p>
     * </li>
     * </ul>
     * <p>
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Kinesis Data Firehose
     * delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A map of attributes with their corresponding values.</p>
     *         <p>
     *         The following lists the names, descriptions, and values of the special request parameters that this
     *         action uses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S
     *         endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of
     *         messages, rather than receiving every message published to the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to Amazon
     *         SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is
     *         otherwise created for Amazon SNS metadata.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
     *         dead-letter queue. Messages that can't be delivered due to client errors (for example, when the
     *         subscribed endpoint is unreachable) or server errors (for example, when the service that powers the
     *         subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or
     *         reprocessing.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Permission to write to the Kinesis Data Firehose delivery stream
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon SNS listed as a trusted entity
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream
     *         subscriptions. For more information, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Kinesis Data
     *         Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The new value for the attribute in JSON format.
     * </p>
     * 
     * @return The new value for the attribute in JSON format.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubscriptionAttributesRequest)) {
            return false;
        }
        SetSubscriptionAttributesRequest other = (SetSubscriptionAttributesRequest) obj;
        return Objects.equals(subscriptionArn(), other.subscriptionArn())
                && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeValue(), other.attributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetSubscriptionAttributesRequest").add("SubscriptionArn", subscriptionArn())
                .add("AttributeName", attributeName()).add("AttributeValue", attributeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionArn":
            return Optional.ofNullable(clazz.cast(subscriptionArn()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSubscriptionAttributesRequest, T> g) {
        return obj -> g.apply((SetSubscriptionAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
        /**
         * <p>
         * The ARN of the subscription to modify.
         * </p>
         * 
         * @param subscriptionArn
         *        The ARN of the subscription to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * A map of attributes with their corresponding values.
         * </p>
         * <p>
         * The following lists the names, descriptions, and values of the special request parameters that this action
         * uses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S
         * endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of
         * messages, rather than receiving every message published to the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to Amazon SQS
         * or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is
         * otherwise created for Amazon SNS metadata.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
         * dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed
         * endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint
         * becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Permission to write to the Kinesis Data Firehose delivery stream
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon SNS listed as a trusted entity
         * </p>
         * </li>
         * </ul>
         * <p>
         * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream
         * subscriptions. For more information, see <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Kinesis Data
         * Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeName
         *        A map of attributes with their corresponding values.</p>
         *        <p>
         *        The following lists the names, descriptions, and values of the special request parameters that this
         *        action uses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to
         *        HTTP/S endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of
         *        messages, rather than receiving every message published to the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to
         *        Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting,
         *        which is otherwise created for Amazon SNS metadata.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS
         *        dead-letter queue. Messages that can't be delivered due to client errors (for example, when the
         *        subscribed endpoint is unreachable) or server errors (for example, when the service that powers the
         *        subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or
         *        reprocessing.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Permission to write to the Kinesis Data Firehose delivery stream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon SNS listed as a trusted entity
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream
         *        subscriptions. For more information, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Kinesis
         *        Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The new value for the attribute in JSON format.
         * </p>
         * 
         * @param attributeValue
         *        The new value for the attribute in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String subscriptionArn;

        private String attributeName;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubscriptionAttributesRequest model) {
            super(model);
            subscriptionArn(model.subscriptionArn);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSubscriptionAttributesRequest build() {
            return new SetSubscriptionAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
