/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServersResponse extends SmsResponse implements
        ToCopyableBuilder<GetServersResponse.Builder, GetServersResponse> {
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedOn").getter(getter(GetServersResponse::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedOn").build()).build();

    private static final SdkField<String> SERVER_CATALOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverCatalogStatus").getter(getter(GetServersResponse::serverCatalogStatusAsString))
            .setter(setter(Builder::serverCatalogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCatalogStatus").build())
            .build();

    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField
            .<List<Server>> builder(MarshallingType.LIST)
            .memberName("serverList")
            .getter(getter(GetServersResponse::serverList))
            .setter(setter(Builder::serverList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Server> builder(MarshallingType.SDK_POJO)
                                            .constructor(Server::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetServersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_ON_FIELD,
            SERVER_CATALOG_STATUS_FIELD, SERVER_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final Instant lastModifiedOn;

    private final String serverCatalogStatus;

    private final List<Server> serverList;

    private final String nextToken;

    private GetServersResponse(BuilderImpl builder) {
        super(builder);
        this.lastModifiedOn = builder.lastModifiedOn;
        this.serverCatalogStatus = builder.serverCatalogStatus;
        this.serverList = builder.serverList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The time when the server was last modified.
     * </p>
     * 
     * @return The time when the server was last modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * The status of the server catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverCatalogStatus} will return {@link ServerCatalogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverCatalogStatusAsString}.
     * </p>
     * 
     * @return The status of the server catalog.
     * @see ServerCatalogStatus
     */
    public final ServerCatalogStatus serverCatalogStatus() {
        return ServerCatalogStatus.fromValue(serverCatalogStatus);
    }

    /**
     * <p>
     * The status of the server catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverCatalogStatus} will return {@link ServerCatalogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverCatalogStatusAsString}.
     * </p>
     * 
     * @return The status of the server catalog.
     * @see ServerCatalogStatus
     */
    public final String serverCatalogStatusAsString() {
        return serverCatalogStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServerList() {
        return serverList != null && !(serverList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerList} method.
     * </p>
     * 
     * @return Information about the servers.
     */
    public final List<Server> serverList() {
        return serverList;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(serverCatalogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServerList() ? serverList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServersResponse)) {
            return false;
        }
        GetServersResponse other = (GetServersResponse) obj;
        return Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && Objects.equals(serverCatalogStatusAsString(), other.serverCatalogStatusAsString())
                && hasServerList() == other.hasServerList() && Objects.equals(serverList(), other.serverList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServersResponse").add("LastModifiedOn", lastModifiedOn())
                .add("ServerCatalogStatus", serverCatalogStatusAsString())
                .add("ServerList", hasServerList() ? serverList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "serverCatalogStatus":
            return Optional.ofNullable(clazz.cast(serverCatalogStatusAsString()));
        case "serverList":
            return Optional.ofNullable(clazz.cast(serverList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServersResponse, T> g) {
        return obj -> g.apply((GetServersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServersResponse> {
        /**
         * <p>
         * The time when the server was last modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        The time when the server was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * The status of the server catalog.
         * </p>
         * 
         * @param serverCatalogStatus
         *        The status of the server catalog.
         * @see ServerCatalogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCatalogStatus
         */
        Builder serverCatalogStatus(String serverCatalogStatus);

        /**
         * <p>
         * The status of the server catalog.
         * </p>
         * 
         * @param serverCatalogStatus
         *        The status of the server catalog.
         * @see ServerCatalogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCatalogStatus
         */
        Builder serverCatalogStatus(ServerCatalogStatus serverCatalogStatus);

        /**
         * <p>
         * Information about the servers.
         * </p>
         * 
         * @param serverList
         *        Information about the servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Collection<Server> serverList);

        /**
         * <p>
         * Information about the servers.
         * </p>
         * 
         * @param serverList
         *        Information about the servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Server... serverList);

        /**
         * <p>
         * Information about the servers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sms.model.Server.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sms.model.Server#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sms.model.Server.Builder#build()}
         * is called immediately and its result is passed to {@link #serverList(List<Server>)}.
         * 
         * @param serverList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sms.model.Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverList(java.util.Collection<Server>)
         */
        Builder serverList(Consumer<Server.Builder>... serverList);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private Instant lastModifiedOn;

        private String serverCatalogStatus;

        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServersResponse model) {
            super(model);
            lastModifiedOn(model.lastModifiedOn);
            serverCatalogStatus(model.serverCatalogStatus);
            serverList(model.serverList);
            nextToken(model.nextToken);
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getServerCatalogStatus() {
            return serverCatalogStatus;
        }

        public final void setServerCatalogStatus(String serverCatalogStatus) {
            this.serverCatalogStatus = serverCatalogStatus;
        }

        @Override
        public final Builder serverCatalogStatus(String serverCatalogStatus) {
            this.serverCatalogStatus = serverCatalogStatus;
            return this;
        }

        @Override
        public final Builder serverCatalogStatus(ServerCatalogStatus serverCatalogStatus) {
            this.serverCatalogStatus(serverCatalogStatus == null ? null : serverCatalogStatus.toString());
            return this;
        }

        public final List<Server.Builder> getServerList() {
            List<Server.Builder> result = ServerListCopier.copyToBuilder(this.serverList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server... serverList) {
            serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder>... serverList) {
            serverList(Stream.of(serverList).map(c -> Server.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetServersResponse build() {
            return new GetServersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
