/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse;

public class ListProtectionGroupsPublisher
implements SdkPublisher<ListProtectionGroupsResponse> {
    private final ShieldAsyncClient client;
    private final ListProtectionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectionGroupsPublisher(ShieldAsyncClient client, ListProtectionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectionGroupsPublisher(ShieldAsyncClient client, ListProtectionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProtectionGroupsResponseFetcher
    implements AsyncPageFetcher<ListProtectionGroupsResponse> {
        private ListProtectionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectionGroupsResponse> nextPage(ListProtectionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectionGroupsPublisher.this.client.listProtectionGroups(ListProtectionGroupsPublisher.this.firstRequest);
            }
            return ListProtectionGroupsPublisher.this.client.listProtectionGroups((ListProtectionGroupsRequest)((Object)ListProtectionGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

