/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineAliasListCopier;
import software.amazon.awssdk.services.sfn.model.StateMachineAliasListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStateMachineAliasesResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListStateMachineAliasesResponse> {
    private static final SdkField<List<StateMachineAliasListItem>> STATE_MACHINE_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateMachineAliases").getter(ListStateMachineAliasesResponse.getter(ListStateMachineAliasesResponse::stateMachineAliases)).setter(ListStateMachineAliasesResponse.setter(Builder::stateMachineAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateMachineAliasListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStateMachineAliasesResponse.getter(ListStateMachineAliasesResponse::nextToken)).setter(ListStateMachineAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIASES_FIELD, NEXT_TOKEN_FIELD));
    private final List<StateMachineAliasListItem> stateMachineAliases;
    private final String nextToken;

    private ListStateMachineAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliases = builder.stateMachineAliases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStateMachineAliases() {
        return this.stateMachineAliases != null && !(this.stateMachineAliases instanceof SdkAutoConstructList);
    }

    public final List<StateMachineAliasListItem> stateMachineAliases() {
        return this.stateMachineAliases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateMachineAliases() ? this.stateMachineAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachineAliasesResponse)) {
            return false;
        }
        ListStateMachineAliasesResponse other = (ListStateMachineAliasesResponse)((Object)obj);
        return this.hasStateMachineAliases() == other.hasStateMachineAliases() && Objects.equals(this.stateMachineAliases(), other.stateMachineAliases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStateMachineAliasesResponse").add("StateMachineAliases", this.hasStateMachineAliases() ? this.stateMachineAliases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineAliases": {
                return Optional.ofNullable(clazz.cast(this.stateMachineAliases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStateMachineAliasesResponse, T> g) {
        return obj -> g.apply((ListStateMachineAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<StateMachineAliasListItem> stateMachineAliases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachineAliasesResponse model) {
            super(model);
            this.stateMachineAliases(model.stateMachineAliases);
            this.nextToken(model.nextToken);
        }

        public final List<StateMachineAliasListItem.Builder> getStateMachineAliases() {
            List<StateMachineAliasListItem.Builder> result = StateMachineAliasListCopier.copyToBuilder(this.stateMachineAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateMachineAliases(Collection<StateMachineAliasListItem.BuilderImpl> stateMachineAliases) {
            this.stateMachineAliases = StateMachineAliasListCopier.copyFromBuilder(stateMachineAliases);
        }

        @Override
        public final Builder stateMachineAliases(Collection<StateMachineAliasListItem> stateMachineAliases) {
            this.stateMachineAliases = StateMachineAliasListCopier.copy(stateMachineAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineAliases(StateMachineAliasListItem ... stateMachineAliases) {
            this.stateMachineAliases(Arrays.asList(stateMachineAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineAliases(Consumer<StateMachineAliasListItem.Builder> ... stateMachineAliases) {
            this.stateMachineAliases(Stream.of(stateMachineAliases).map(c -> (StateMachineAliasListItem)((StateMachineAliasListItem.Builder)StateMachineAliasListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStateMachineAliasesResponse build() {
            return new ListStateMachineAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStateMachineAliasesResponse> {
        public Builder stateMachineAliases(Collection<StateMachineAliasListItem> var1);

        public Builder stateMachineAliases(StateMachineAliasListItem ... var1);

        public Builder stateMachineAliases(Consumer<StateMachineAliasListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

