/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineVersionListCopier;
import software.amazon.awssdk.services.sfn.model.StateMachineVersionListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStateMachineVersionsResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListStateMachineVersionsResponse> {
    private static final SdkField<List<StateMachineVersionListItem>> STATE_MACHINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateMachineVersions").getter(ListStateMachineVersionsResponse.getter(ListStateMachineVersionsResponse::stateMachineVersions)).setter(ListStateMachineVersionsResponse.setter(Builder::stateMachineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateMachineVersionListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStateMachineVersionsResponse.getter(ListStateMachineVersionsResponse::nextToken)).setter(ListStateMachineVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StateMachineVersionListItem> stateMachineVersions;
    private final String nextToken;

    private ListStateMachineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineVersions = builder.stateMachineVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStateMachineVersions() {
        return this.stateMachineVersions != null && !(this.stateMachineVersions instanceof SdkAutoConstructList);
    }

    public final List<StateMachineVersionListItem> stateMachineVersions() {
        return this.stateMachineVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateMachineVersions() ? this.stateMachineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachineVersionsResponse)) {
            return false;
        }
        ListStateMachineVersionsResponse other = (ListStateMachineVersionsResponse)((Object)obj);
        return this.hasStateMachineVersions() == other.hasStateMachineVersions() && Objects.equals(this.stateMachineVersions(), other.stateMachineVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStateMachineVersionsResponse").add("StateMachineVersions", this.hasStateMachineVersions() ? this.stateMachineVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineVersions": {
                return Optional.ofNullable(clazz.cast(this.stateMachineVersions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStateMachineVersionsResponse, T> g) {
        return obj -> g.apply((ListStateMachineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<StateMachineVersionListItem> stateMachineVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachineVersionsResponse model) {
            super(model);
            this.stateMachineVersions(model.stateMachineVersions);
            this.nextToken(model.nextToken);
        }

        public final List<StateMachineVersionListItem.Builder> getStateMachineVersions() {
            List<StateMachineVersionListItem.Builder> result = StateMachineVersionListCopier.copyToBuilder(this.stateMachineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateMachineVersions(Collection<StateMachineVersionListItem.BuilderImpl> stateMachineVersions) {
            this.stateMachineVersions = StateMachineVersionListCopier.copyFromBuilder(stateMachineVersions);
        }

        @Override
        public final Builder stateMachineVersions(Collection<StateMachineVersionListItem> stateMachineVersions) {
            this.stateMachineVersions = StateMachineVersionListCopier.copy(stateMachineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineVersions(StateMachineVersionListItem ... stateMachineVersions) {
            this.stateMachineVersions(Arrays.asList(stateMachineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachineVersions(Consumer<StateMachineVersionListItem.Builder> ... stateMachineVersions) {
            this.stateMachineVersions(Stream.of(stateMachineVersions).map(c -> (StateMachineVersionListItem)((StateMachineVersionListItem.Builder)StateMachineVersionListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStateMachineVersionsResponse build() {
            return new ListStateMachineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStateMachineVersionsResponse> {
        public Builder stateMachineVersions(Collection<StateMachineVersionListItem> var1);

        public Builder stateMachineVersions(StateMachineVersionListItem ... var1);

        public Builder stateMachineVersions(Consumer<StateMachineVersionListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

