/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetActivityTaskRequest extends SfnRequest implements
        ToCopyableBuilder<GetActivityTaskRequest.Builder, GetActivityTaskRequest> {
    private static final SdkField<String> ACTIVITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityArn").getter(getter(GetActivityTaskRequest::activityArn)).setter(setter(Builder::activityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityArn").build()).build();

    private static final SdkField<String> WORKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerName").getter(getter(GetActivityTaskRequest::workerName)).setter(setter(Builder::workerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ARN_FIELD,
            WORKER_NAME_FIELD));

    private final String activityArn;

    private final String workerName;

    private GetActivityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.workerName = builder.workerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using
     * <a>CreateActivity</a>.)
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
     *         using <a>CreateActivity</a>.)
     */
    public final String activityArn() {
        return activityArn;
    }

    /**
     * <p>
     * You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used
     * when it is logged in the execution history.
     * </p>
     * 
     * @return You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name
     *         is used when it is logged in the execution history.
     */
    public final String workerName() {
        return workerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(workerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActivityTaskRequest)) {
            return false;
        }
        GetActivityTaskRequest other = (GetActivityTaskRequest) obj;
        return Objects.equals(activityArn(), other.activityArn()) && Objects.equals(workerName(), other.workerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetActivityTaskRequest").add("ActivityArn", activityArn()).add("WorkerName", workerName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityArn":
            return Optional.ofNullable(clazz.cast(activityArn()));
        case "workerName":
            return Optional.ofNullable(clazz.cast(workerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetActivityTaskRequest, T> g) {
        return obj -> g.apply((GetActivityTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetActivityTaskRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
         * using <a>CreateActivity</a>.)
         * </p>
         * 
         * @param activityArn
         *        The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the
         *        task using <a>CreateActivity</a>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityArn(String activityArn);

        /**
         * <p>
         * You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is
         * used when it is logged in the execution history.
         * </p>
         * 
         * @param workerName
         *        You can provide an arbitrary name in order to identify the worker that the task is assigned to. This
         *        name is used when it is logged in the execution history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerName(String workerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String activityArn;

        private String workerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActivityTaskRequest model) {
            super(model);
            activityArn(model.activityArn);
            workerName(model.workerName);
        }

        public final String getActivityArn() {
            return activityArn;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final String getWorkerName() {
            return workerName;
        }

        public final void setWorkerName(String workerName) {
            this.workerName = workerName;
        }

        @Override
        public final Builder workerName(String workerName) {
            this.workerName = workerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetActivityTaskRequest build() {
            return new GetActivityTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
