/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;

public class ListContactListsPublisher
implements SdkPublisher<ListContactListsResponse> {
    private final SesV2AsyncClient client;
    private final ListContactListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactListsPublisher(SesV2AsyncClient client, ListContactListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactListsPublisher(SesV2AsyncClient client, ListContactListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListContactListsResponseFetcher
    implements AsyncPageFetcher<ListContactListsResponse> {
        private ListContactListsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactListsResponse> nextPage(ListContactListsResponse previousPage) {
            if (previousPage == null) {
                return ListContactListsPublisher.this.client.listContactLists(ListContactListsPublisher.this.firstRequest);
            }
            return ListContactListsPublisher.this.client.listContactLists((ListContactListsRequest)((Object)ListContactListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

