/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.SendDataPoint;
import software.amazon.awssdk.services.ses.model.SendDataPointListCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSendStatisticsResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetSendStatisticsResponse> {
    private static final SdkField<List<SendDataPoint>> SEND_DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SendDataPoints").getter(GetSendStatisticsResponse.getter(GetSendStatisticsResponse::sendDataPoints)).setter(GetSendStatisticsResponse.setter(Builder::sendDataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendDataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SendDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_DATA_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSendStatisticsResponse.memberNameToFieldInitializer();
    private final List<SendDataPoint> sendDataPoints;

    private GetSendStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.sendDataPoints = builder.sendDataPoints;
    }

    public final boolean hasSendDataPoints() {
        return this.sendDataPoints != null && !(this.sendDataPoints instanceof SdkAutoConstructList);
    }

    public final List<SendDataPoint> sendDataPoints() {
        return this.sendDataPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSendDataPoints() ? this.sendDataPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendStatisticsResponse)) {
            return false;
        }
        GetSendStatisticsResponse other = (GetSendStatisticsResponse)((Object)obj);
        return this.hasSendDataPoints() == other.hasSendDataPoints() && Objects.equals(this.sendDataPoints(), other.sendDataPoints());
    }

    public final String toString() {
        return ToString.builder((String)"GetSendStatisticsResponse").add("SendDataPoints", this.hasSendDataPoints() ? this.sendDataPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendDataPoints": {
                return Optional.ofNullable(clazz.cast(this.sendDataPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SendDataPoint>>> map = new HashMap<String, SdkField<List<SendDataPoint>>>();
        map.put("SendDataPoints", SEND_DATA_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSendStatisticsResponse, T> g) {
        return obj -> g.apply((GetSendStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<SendDataPoint> sendDataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendStatisticsResponse model) {
            super(model);
            this.sendDataPoints(model.sendDataPoints);
        }

        public final List<SendDataPoint.Builder> getSendDataPoints() {
            List<SendDataPoint.Builder> result = SendDataPointListCopier.copyToBuilder(this.sendDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSendDataPoints(Collection<SendDataPoint.BuilderImpl> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copyFromBuilder(sendDataPoints);
        }

        @Override
        public final Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copy(sendDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(SendDataPoint ... sendDataPoints) {
            this.sendDataPoints(Arrays.asList(sendDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(Consumer<SendDataPoint.Builder> ... sendDataPoints) {
            this.sendDataPoints(Stream.of(sendDataPoints).map(c -> (SendDataPoint)((SendDataPoint.Builder)SendDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSendStatisticsResponse build() {
            return new GetSendStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSendStatisticsResponse> {
        public Builder sendDataPoints(Collection<SendDataPoint> var1);

        public Builder sendDataPoints(SendDataPoint ... var1);

        public Builder sendDataPoints(Consumer<SendDataPoint.Builder> ... var1);
    }
}

