/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.DeliveryOptions;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetDeliveryOptionsRequest
extends SesRequest
implements ToCopyableBuilder<Builder, PutConfigurationSetDeliveryOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(PutConfigurationSetDeliveryOptionsRequest.getter(PutConfigurationSetDeliveryOptionsRequest::configurationSetName)).setter(PutConfigurationSetDeliveryOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<DeliveryOptions> DELIVERY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryOptions").getter(PutConfigurationSetDeliveryOptionsRequest.getter(PutConfigurationSetDeliveryOptionsRequest::deliveryOptions)).setter(PutConfigurationSetDeliveryOptionsRequest.setter(Builder::deliveryOptions)).constructor(DeliveryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, DELIVERY_OPTIONS_FIELD));
    private final String configurationSetName;
    private final DeliveryOptions deliveryOptions;

    private PutConfigurationSetDeliveryOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.deliveryOptions = builder.deliveryOptions;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final DeliveryOptions deliveryOptions() {
        return this.deliveryOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetDeliveryOptionsRequest)) {
            return false;
        }
        PutConfigurationSetDeliveryOptionsRequest other = (PutConfigurationSetDeliveryOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.deliveryOptions(), other.deliveryOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfigurationSetDeliveryOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("DeliveryOptions", (Object)this.deliveryOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "DeliveryOptions": {
                return Optional.ofNullable(clazz.cast(this.deliveryOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetDeliveryOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetDeliveryOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private DeliveryOptions deliveryOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetDeliveryOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.deliveryOptions(model.deliveryOptions);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final DeliveryOptions.Builder getDeliveryOptions() {
            return this.deliveryOptions != null ? this.deliveryOptions.toBuilder() : null;
        }

        public final void setDeliveryOptions(DeliveryOptions.BuilderImpl deliveryOptions) {
            this.deliveryOptions = deliveryOptions != null ? deliveryOptions.build() : null;
        }

        @Override
        public final Builder deliveryOptions(DeliveryOptions deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetDeliveryOptionsRequest build() {
            return new PutConfigurationSetDeliveryOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetDeliveryOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder deliveryOptions(DeliveryOptions var1);

        default public Builder deliveryOptions(Consumer<DeliveryOptions.Builder> deliveryOptions) {
            return this.deliveryOptions((DeliveryOptions)((DeliveryOptions.Builder)DeliveryOptions.builder().applyMutation(deliveryOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

