/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the quota period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuotaPeriod implements SdkPojo, Serializable, ToCopyableBuilder<QuotaPeriod.Builder, QuotaPeriod> {
    private static final SdkField<Integer> PERIOD_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodValue").getter(getter(QuotaPeriod::periodValue)).setter(setter(Builder::periodValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodValue").build()).build();

    private static final SdkField<String> PERIOD_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeriodUnit").getter(getter(QuotaPeriod::periodUnitAsString)).setter(setter(Builder::periodUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_VALUE_FIELD,
            PERIOD_UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer periodValue;

    private final String periodUnit;

    private QuotaPeriod(BuilderImpl builder) {
        this.periodValue = builder.periodValue;
        this.periodUnit = builder.periodUnit;
    }

    /**
     * <p>
     * The value.
     * </p>
     * 
     * @return The value.
     */
    public final Integer periodValue() {
        return periodValue;
    }

    /**
     * <p>
     * The time unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodUnit} will
     * return {@link PeriodUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodUnitAsString}.
     * </p>
     * 
     * @return The time unit.
     * @see PeriodUnit
     */
    public final PeriodUnit periodUnit() {
        return PeriodUnit.fromValue(periodUnit);
    }

    /**
     * <p>
     * The time unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodUnit} will
     * return {@link PeriodUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodUnitAsString}.
     * </p>
     * 
     * @return The time unit.
     * @see PeriodUnit
     */
    public final String periodUnitAsString() {
        return periodUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodValue());
        hashCode = 31 * hashCode + Objects.hashCode(periodUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaPeriod)) {
            return false;
        }
        QuotaPeriod other = (QuotaPeriod) obj;
        return Objects.equals(periodValue(), other.periodValue())
                && Objects.equals(periodUnitAsString(), other.periodUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuotaPeriod").add("PeriodValue", periodValue()).add("PeriodUnit", periodUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeriodValue":
            return Optional.ofNullable(clazz.cast(periodValue()));
        case "PeriodUnit":
            return Optional.ofNullable(clazz.cast(periodUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuotaPeriod, T> g) {
        return obj -> g.apply((QuotaPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuotaPeriod> {
        /**
         * <p>
         * The value.
         * </p>
         * 
         * @param periodValue
         *        The value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodValue(Integer periodValue);

        /**
         * <p>
         * The time unit.
         * </p>
         * 
         * @param periodUnit
         *        The time unit.
         * @see PeriodUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodUnit
         */
        Builder periodUnit(String periodUnit);

        /**
         * <p>
         * The time unit.
         * </p>
         * 
         * @param periodUnit
         *        The time unit.
         * @see PeriodUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodUnit
         */
        Builder periodUnit(PeriodUnit periodUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer periodValue;

        private String periodUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaPeriod model) {
            periodValue(model.periodValue);
            periodUnit(model.periodUnit);
        }

        public final Integer getPeriodValue() {
            return periodValue;
        }

        public final void setPeriodValue(Integer periodValue) {
            this.periodValue = periodValue;
        }

        @Override
        public final Builder periodValue(Integer periodValue) {
            this.periodValue = periodValue;
            return this;
        }

        public final String getPeriodUnit() {
            return periodUnit;
        }

        public final void setPeriodUnit(String periodUnit) {
            this.periodUnit = periodUnit;
        }

        @Override
        public final Builder periodUnit(String periodUnit) {
            this.periodUnit = periodUnit;
            return this;
        }

        @Override
        public final Builder periodUnit(PeriodUnit periodUnit) {
            this.periodUnit(periodUnit == null ? null : periodUnit.toString());
            return this;
        }

        @Override
        public QuotaPeriod build() {
            return new QuotaPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
