/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse;

public class ListAttributeGroupsIterable
implements SdkIterable<ListAttributeGroupsResponse> {
    private final ServiceCatalogAppRegistryClient client;
    private final ListAttributeGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttributeGroupsIterable(ServiceCatalogAppRegistryClient client, ListAttributeGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttributeGroupsResponseFetcher();
    }

    public Iterator<ListAttributeGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttributeGroupSummary> attributeGroups() {
        Function<ListAttributeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroups() != null) {
                return response.attributeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttributeGroupsResponseFetcher
    implements SyncPageFetcher<ListAttributeGroupsResponse> {
        private ListAttributeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttributeGroupsResponse nextPage(ListAttributeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAttributeGroupsIterable.this.client.listAttributeGroups(ListAttributeGroupsIterable.this.firstRequest);
            }
            return ListAttributeGroupsIterable.this.client.listAttributeGroups((ListAttributeGroupsRequest)((Object)ListAttributeGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

