/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAttributeGroupRequest extends ServiceCatalogAppRegistryRequest implements
        ToCopyableBuilder<UpdateAttributeGroupRequest.Builder, UpdateAttributeGroupRequest> {
    private static final SdkField<String> ATTRIBUTE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeGroup").getter(getter(UpdateAttributeGroupRequest::attributeGroup))
            .setter(setter(Builder::attributeGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("attributeGroup").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAttributeGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAttributeGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributes").getter(getter(UpdateAttributeGroupRequest::attributes)).setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUP_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTES_FIELD));

    private final String attributeGroup;

    private final String name;

    private final String description;

    private final String attributes;

    private UpdateAttributeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.attributeGroup = builder.attributeGroup;
        this.name = builder.name;
        this.description = builder.description;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The name, ID, or ARN of the attribute group that holds the attributes to describe the application.
     * </p>
     * 
     * @return The name, ID, or ARN of the attribute group that holds the attributes to describe the application.
     */
    public final String attributeGroup() {
        return attributeGroup;
    }

    /**
     * <p>
     * Deprecated: The new name of the attribute group. The name must be unique in the region in which you are updating
     * the attribute group. Please do not use this field as we have stopped supporting name updates.
     * </p>
     * 
     * @return Deprecated: The new name of the attribute group. The name must be unique in the region in which you are
     *         updating the attribute group. Please do not use this field as we have stopped supporting name updates.
     * @deprecated Name update for attribute group is deprecated.
     */
    @Deprecated
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the attribute group that the user provides.
     * </p>
     * 
     * @return The description of the attribute group that the user provides.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an
     * application and its components.
     * </p>
     * 
     * @return A JSON string in the form of nested key-value pairs that represent the attributes in the group and
     *         describes an application and its components.
     */
    public final String attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAttributeGroupRequest)) {
            return false;
        }
        UpdateAttributeGroupRequest other = (UpdateAttributeGroupRequest) obj;
        return Objects.equals(attributeGroup(), other.attributeGroup()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAttributeGroupRequest").add("AttributeGroup", attributeGroup()).add("Name", name())
                .add("Description", description()).add("Attributes", attributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeGroup":
            return Optional.ofNullable(clazz.cast(attributeGroup()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAttributeGroupRequest, T> g) {
        return obj -> g.apply((UpdateAttributeGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAttributeGroupRequest> {
        /**
         * <p>
         * The name, ID, or ARN of the attribute group that holds the attributes to describe the application.
         * </p>
         * 
         * @param attributeGroup
         *        The name, ID, or ARN of the attribute group that holds the attributes to describe the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroup(String attributeGroup);

        /**
         * <p>
         * Deprecated: The new name of the attribute group. The name must be unique in the region in which you are
         * updating the attribute group. Please do not use this field as we have stopped supporting name updates.
         * </p>
         * 
         * @param name
         *        Deprecated: The new name of the attribute group. The name must be unique in the region in which you
         *        are updating the attribute group. Please do not use this field as we have stopped supporting name
         *        updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Name update for attribute group is deprecated.
         */
        @Deprecated
        Builder name(String name);

        /**
         * <p>
         * The description of the attribute group that the user provides.
         * </p>
         * 
         * @param description
         *        The description of the attribute group that the user provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes
         * an application and its components.
         * </p>
         * 
         * @param attributes
         *        A JSON string in the form of nested key-value pairs that represent the attributes in the group and
         *        describes an application and its components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(String attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryRequest.BuilderImpl implements Builder {
        private String attributeGroup;

        private String name;

        private String description;

        private String attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAttributeGroupRequest model) {
            super(model);
            attributeGroup(model.attributeGroup);
            name(model.name);
            description(model.description);
            attributes(model.attributes);
        }

        public final String getAttributeGroup() {
            return attributeGroup;
        }

        public final void setAttributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
        }

        @Override
        public final Builder attributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
            return this;
        }

        @Deprecated
        public final String getName() {
            return name;
        }

        @Deprecated
        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Deprecated
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAttributes() {
            return attributes;
        }

        public final void setAttributes(String attributes) {
            this.attributes = attributes;
        }

        @Override
        public final Builder attributes(String attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAttributeGroupRequest build() {
            return new UpdateAttributeGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
