/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DuplicateResourceException;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.InvalidParametersException;
import software.amazon.awssdk.services.servicecatalog.model.InvalidStateException;
import software.amazon.awssdk.services.servicecatalog.model.LimitExceededException;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest;
import software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse;
import software.amazon.awssdk.services.servicecatalog.model.OperationNotSupportedException;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.ResourceInUseException;
import software.amazon.awssdk.services.servicecatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogException;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionNotMigratedException;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable;
import software.amazon.awssdk.services.servicecatalog.transform.AcceptPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateBudgetWithResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociatePrincipalWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateProductWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateServiceActionWithProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateTagOptionWithResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.BatchAssociateServiceActionWithProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.BatchDisassociateServiceActionFromProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CopyProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeCopyProductStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioShareStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioSharesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductViewRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningParametersRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeRecordRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeServiceActionExecutionParametersRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisableAwsOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateBudgetFromResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociatePrincipalFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateProductFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateServiceActionFromProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateTagOptionFromResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.EnableAwsOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ExecuteProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ExecuteProvisionedProductServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.GetAwsOrganizationsAccessStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.GetProvisionedProductOutputsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ImportAsProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListAcceptedPortfolioSharesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListBudgetsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListConstraintsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListLaunchPathsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListOrganizationPortfolioAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfolioAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosForProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPrincipalsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisionedProductPlansRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsForServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListRecordHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListResourcesForTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListServiceActionsForProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListServiceActionsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListStackInstancesForProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListTagOptionsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.NotifyProvisionProductEngineWorkflowResultRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.NotifyTerminateProvisionedProductEngineWorkflowResultRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.NotifyUpdateProvisionedProductEngineWorkflowResultRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisionProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.RejectPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ScanProvisionedProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProvisionedProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.TerminateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductPropertiesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateTagOptionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ServiceCatalogClient}.
 *
 * @see ServiceCatalogClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultServiceCatalogClient implements ServiceCatalogClient {
    private static final Logger log = Logger.loggerFor(DefaultServiceCatalogClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ServiceCatalogServiceClientConfiguration serviceClientConfiguration;

    protected DefaultServiceCatalogClient(ServiceCatalogServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     *
     * @param acceptPortfolioShareRequest
     * @return Result of the AcceptPortfolioShare operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AcceptPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptPortfolioShareResponse acceptPortfolioShare(AcceptPortfolioShareRequest acceptPortfolioShareRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptPortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptPortfolioShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptPortfolioShare");

            return clientHandler.execute(new ClientExecutionParams<AcceptPortfolioShareRequest, AcceptPortfolioShareResponse>()
                    .withOperationName("AcceptPortfolioShare").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(acceptPortfolioShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptPortfolioShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     * @return Result of the AssociateBudgetWithResource operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateBudgetWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateBudgetWithResourceResponse associateBudgetWithResource(
            AssociateBudgetWithResourceRequest associateBudgetWithResourceRequest) throws InvalidParametersException,
            DuplicateResourceException, LimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateBudgetWithResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateBudgetWithResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBudgetWithResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBudgetWithResource");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateBudgetWithResourceRequest, AssociateBudgetWithResourceResponse>()
                            .withOperationName("AssociateBudgetWithResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateBudgetWithResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateBudgetWithResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     * <p>
     * If you share the portfolio with principal name sharing enabled, the <code>PrincipalARN</code> association is
     * included in the share.
     * </p>
     * <p>
     * The <code>PortfolioID</code>, <code>PrincipalARN</code>, and <code>PrincipalType</code> parameters are required.
     * </p>
     * <p>
     * You can associate a maximum of 10 Principals with a portfolio using <code>PrincipalType</code> as
     * <code>IAM_PATTERN</code>
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param associatePrincipalWithPortfolioRequest
     * @return Result of the AssociatePrincipalWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociatePrincipalWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociatePrincipalWithPortfolioResponse associatePrincipalWithPortfolio(
            AssociatePrincipalWithPortfolioRequest associatePrincipalWithPortfolioRequest) throws InvalidParametersException,
            ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociatePrincipalWithPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociatePrincipalWithPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associatePrincipalWithPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePrincipalWithPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociatePrincipalWithPortfolioRequest, AssociatePrincipalWithPortfolioResponse>()
                            .withOperationName("AssociatePrincipalWithPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associatePrincipalWithPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociatePrincipalWithPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     * @return Result of the AssociateProductWithPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateProductWithPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateProductWithPortfolioResponse associateProductWithPortfolio(
            AssociateProductWithPortfolioRequest associateProductWithPortfolioRequest) throws InvalidParametersException,
            ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateProductWithPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateProductWithPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateProductWithPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateProductWithPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateProductWithPortfolioRequest, AssociateProductWithPortfolioResponse>()
                            .withOperationName("AssociateProductWithPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateProductWithPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateProductWithPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     * @return Result of the AssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateServiceActionWithProvisioningArtifactResponse associateServiceActionWithProvisioningArtifact(
            AssociateServiceActionWithProvisioningArtifactRequest associateServiceActionWithProvisioningArtifactRequest)
            throws ResourceNotFoundException, DuplicateResourceException, LimitExceededException, InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateServiceActionWithProvisioningArtifactResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateServiceActionWithProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateServiceActionWithProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateServiceActionWithProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateServiceActionWithProvisioningArtifactRequest, AssociateServiceActionWithProvisioningArtifactResponse>()
                            .withOperationName("AssociateServiceActionWithProvisioningArtifact")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateServiceActionWithProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateServiceActionWithProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     * @return Result of the AssociateTagOptionWithResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.AssociateTagOptionWithResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTagOptionWithResourceResponse associateTagOptionWithResource(
            AssociateTagOptionWithResourceRequest associateTagOptionWithResourceRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException,
            InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTagOptionWithResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTagOptionWithResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTagOptionWithResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTagOptionWithResource");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTagOptionWithResourceRequest, AssociateTagOptionWithResourceResponse>()
                            .withOperationName("AssociateTagOptionWithResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateTagOptionWithResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTagOptionWithResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     * @return Result of the BatchAssociateServiceActionWithProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateServiceActionWithProvisioningArtifactResponse batchAssociateServiceActionWithProvisioningArtifact(
            BatchAssociateServiceActionWithProvisioningArtifactRequest batchAssociateServiceActionWithProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateServiceActionWithProvisioningArtifactResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchAssociateServiceActionWithProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateServiceActionWithProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateServiceActionWithProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateServiceActionWithProvisioningArtifactRequest, BatchAssociateServiceActionWithProvisioningArtifactResponse>()
                            .withOperationName("BatchAssociateServiceActionWithProvisioningArtifact")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchAssociateServiceActionWithProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new BatchAssociateServiceActionWithProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     * @return Result of the BatchDisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateServiceActionFromProvisioningArtifactResponse batchDisassociateServiceActionFromProvisioningArtifact(
            BatchDisassociateServiceActionFromProvisioningArtifactRequest batchDisassociateServiceActionFromProvisioningArtifactRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateServiceActionFromProvisioningArtifactResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDisassociateServiceActionFromProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateServiceActionFromProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "BatchDisassociateServiceActionFromProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateServiceActionFromProvisioningArtifactRequest, BatchDisassociateServiceActionFromProvisioningArtifactResponse>()
                            .withOperationName("BatchDisassociateServiceActionFromProvisioningArtifact")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchDisassociateServiceActionFromProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new BatchDisassociateServiceActionFromProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same Region or
     * another Region. If you copy a product to another account, you must first share the product in a portfolio using
     * <a>CreatePortfolioShare</a>.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     *
     * @param copyProductRequest
     * @return Result of the CopyProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CopyProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyProductResponse copyProduct(CopyProductRequest copyProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopyProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CopyProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyProduct");

            return clientHandler.execute(new ClientExecutionParams<CopyProductRequest, CopyProductResponse>()
                    .withOperationName("CopyProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createConstraintRequest
     * @return Result of the CreateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConstraintResponse createConstraint(CreateConstraintRequest createConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConstraintResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateConstraintResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConstraint");

            return clientHandler.execute(new ClientExecutionParams<CreateConstraintRequest, CreateConstraintResponse>()
                    .withOperationName("CreateConstraint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createConstraintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConstraintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createPortfolioRequest
     * @return Result of the CreatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePortfolioResponse createPortfolio(CreatePortfolioRequest createPortfolioRequest)
            throws InvalidParametersException, LimitExceededException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortfolio");

            return clientHandler.execute(new ClientExecutionParams<CreatePortfolioRequest, CreatePortfolioResponse>()
                    .withOperationName("CreatePortfolio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPortfolioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param createPortfolioShareRequest
     * @return Result of the CreatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePortfolioShareResponse createPortfolioShare(CreatePortfolioShareRequest createPortfolioShareRequest)
            throws ResourceNotFoundException, LimitExceededException, InvalidParametersException, OperationNotSupportedException,
            InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePortfolioShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortfolioShare");

            return clientHandler.execute(new ClientExecutionParams<CreatePortfolioShareRequest, CreatePortfolioShareResponse>()
                    .withOperationName("CreatePortfolioShare").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPortfolioShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePortfolioShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProductRequest
     * @return Result of the CreateProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateProductResponse createProduct(CreateProductRequest createProductRequest) throws InvalidParametersException,
            LimitExceededException, TagOptionNotMigratedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProduct");

            return clientHandler.execute(new ClientExecutionParams<CreateProductRequest, CreateProductResponse>()
                    .withOperationName("CreateProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a plan.
     * </p>
     * <p>
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating
     * a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILABLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     * @return Result of the CreateProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateProvisionedProductPlanResponse createProvisionedProductPlan(
            CreateProvisionedProductPlanRequest createProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisionedProductPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisionedProductPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisionedProductPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisionedProductPlanRequest, CreateProvisionedProductPlanResponse>()
                            .withOperationName("CreateProvisionedProductPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createProvisionedProductPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisionedProductPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProvisioningArtifactRequest
     * @return Result of the CreateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateProvisioningArtifactResponse createProvisioningArtifact(
            CreateProvisioningArtifactRequest createProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, LimitExceededException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningArtifactRequest, CreateProvisioningArtifactResponse>()
                            .withOperationName("CreateProvisioningArtifact").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     *
     * @param createServiceActionRequest
     * @return Result of the CreateServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateServiceActionResponse createServiceAction(CreateServiceActionRequest createServiceActionRequest)
            throws InvalidParametersException, LimitExceededException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceAction");

            return clientHandler.execute(new ClientExecutionParams<CreateServiceActionRequest, CreateServiceActionResponse>()
                    .withOperationName("CreateServiceAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createServiceActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     *
     * @param createTagOptionRequest
     * @return Result of the CreateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.CreateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTagOptionResponse createTagOption(CreateTagOptionRequest createTagOptionRequest)
            throws TagOptionNotMigratedException, DuplicateResourceException, LimitExceededException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTagOptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTagOption");

            return clientHandler.execute(new ClientExecutionParams<CreateTagOptionRequest, CreateTagOptionResponse>()
                    .withOperationName("CreateTagOption").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTagOptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTagOptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteConstraintRequest
     * @return Result of the DeleteConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConstraintResponse deleteConstraint(DeleteConstraintRequest deleteConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConstraintResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConstraintResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConstraint");

            return clientHandler.execute(new ClientExecutionParams<DeleteConstraintRequest, DeleteConstraintResponse>()
                    .withOperationName("DeleteConstraint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConstraintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConstraintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deletePortfolioRequest
     * @return Result of the DeletePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePortfolioResponse deletePortfolio(DeletePortfolioRequest deletePortfolioRequest)
            throws ResourceNotFoundException, InvalidParametersException, ResourceInUseException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortfolio");

            return clientHandler.execute(new ClientExecutionParams<DeletePortfolioRequest, DeletePortfolioResponse>()
                    .withOperationName("DeletePortfolio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePortfolioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     *
     * @param deletePortfolioShareRequest
     * @return Result of the DeletePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeletePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePortfolioShareResponse deletePortfolioShare(DeletePortfolioShareRequest deletePortfolioShareRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, InvalidStateException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePortfolioShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortfolioShare");

            return clientHandler.execute(new ClientExecutionParams<DeletePortfolioShareRequest, DeletePortfolioShareResponse>()
                    .withOperationName("DeletePortfolioShare").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePortfolioShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePortfolioShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteProductRequest
     * @return Result of the DeleteProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteProductResponse deleteProduct(DeleteProductRequest deleteProductRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, TagOptionNotMigratedException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProduct");

            return clientHandler.execute(new ClientExecutionParams<DeleteProductRequest, DeleteProductResponse>()
                    .withOperationName("DeleteProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     * @return Result of the DeleteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProvisionedProductPlanResponse deleteProvisionedProductPlan(
            DeleteProvisionedProductPlanRequest deleteProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisionedProductPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisionedProductPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisionedProductPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisionedProductPlanRequest, DeleteProvisionedProductPlanResponse>()
                            .withOperationName("DeleteProvisionedProductPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteProvisionedProductPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisionedProductPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     * @return Result of the DeleteProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProvisioningArtifactResponse deleteProvisioningArtifact(
            DeleteProvisioningArtifactRequest deleteProvisioningArtifactRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningArtifactRequest, DeleteProvisioningArtifactResponse>()
                            .withOperationName("DeleteProvisioningArtifact").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     *
     * @param deleteServiceActionRequest
     * @return Result of the DeleteServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteServiceActionResponse deleteServiceAction(DeleteServiceActionRequest deleteServiceActionRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceAction");

            return clientHandler.execute(new ClientExecutionParams<DeleteServiceActionRequest, DeleteServiceActionResponse>()
                    .withOperationName("DeleteServiceAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteServiceActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     *
     * @param deleteTagOptionRequest
     * @return Result of the DeleteTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DeleteTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTagOptionResponse deleteTagOption(DeleteTagOptionRequest deleteTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTagOptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTagOption");

            return clientHandler.execute(new ClientExecutionParams<DeleteTagOptionRequest, DeleteTagOptionResponse>()
                    .withOperationName("DeleteTagOption").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTagOptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTagOptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     *
     * @param describeConstraintRequest
     * @return Result of the DescribeConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConstraintResponse describeConstraint(DescribeConstraintRequest describeConstraintRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConstraintResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConstraintResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConstraint");

            return clientHandler.execute(new ClientExecutionParams<DescribeConstraintRequest, DescribeConstraintResponse>()
                    .withOperationName("DescribeConstraint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeConstraintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeConstraintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     *
     * @param describeCopyProductStatusRequest
     * @return Result of the DescribeCopyProductStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeCopyProductStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCopyProductStatusResponse describeCopyProductStatus(
            DescribeCopyProductStatusRequest describeCopyProductStatusRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCopyProductStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCopyProductStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCopyProductStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCopyProductStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCopyProductStatusRequest, DescribeCopyProductStatusResponse>()
                            .withOperationName("DescribeCopyProductStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCopyProductStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCopyProductStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param describePortfolioRequest
     * @return Result of the DescribePortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePortfolioResponse describePortfolio(DescribePortfolioRequest describePortfolioRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolio");

            return clientHandler.execute(new ClientExecutionParams<DescribePortfolioRequest, DescribePortfolioResponse>()
                    .withOperationName("DescribePortfolio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePortfolioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     * @return Result of the DescribePortfolioShareStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShareStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePortfolioShareStatusResponse describePortfolioShareStatus(
            DescribePortfolioShareStatusRequest describePortfolioShareStatusRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePortfolioShareStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePortfolioShareStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioShareStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolioShareStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePortfolioShareStatusRequest, DescribePortfolioShareStatusResponse>()
                            .withOperationName("DescribePortfolioShareStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePortfolioShareStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePortfolioShareStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return Result of the DescribePortfolioShares operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePortfolioSharesResponse describePortfolioShares(DescribePortfolioSharesRequest describePortfolioSharesRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePortfolioSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePortfolioSharesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolioShares");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePortfolioSharesRequest, DescribePortfolioSharesResponse>()
                            .withOperationName("DescribePortfolioShares").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePortfolioSharesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePortfolioSharesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client
     *             .describePortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesIterable responses = client.describePortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribePortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePortfolioSharesIterable describePortfolioSharesPaginator(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new DescribePortfolioSharesIterable(this, applyPaginatorUserAgent(describePortfolioSharesRequest));
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     * <note>
     * <p>
     * Running this operation with administrator access results in a failure. <a>DescribeProductAsAdmin</a> should be
     * used instead.
     * </p>
     * </note>
     *
     * @param describeProductRequest
     * @return Result of the DescribeProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProductResponse describeProduct(DescribeProductRequest describeProductRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProduct");

            return clientHandler.execute(new ClientExecutionParams<DescribeProductRequest, DescribeProductResponse>()
                    .withOperationName("DescribeProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     *
     * @param describeProductAsAdminRequest
     * @return Result of the DescribeProductAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProductAsAdminResponse describeProductAsAdmin(DescribeProductAsAdminRequest describeProductAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProductAsAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProductAsAdminResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductAsAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProductAsAdmin");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProductAsAdminRequest, DescribeProductAsAdminResponse>()
                            .withOperationName("DescribeProductAsAdmin").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeProductAsAdminRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProductAsAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     *
     * @param describeProductViewRequest
     * @return Result of the DescribeProductView operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProductView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProductViewResponse describeProductView(DescribeProductViewRequest describeProductViewRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProductViewResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProductViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProductView");

            return clientHandler.execute(new ClientExecutionParams<DescribeProductViewRequest, DescribeProductViewResponse>()
                    .withOperationName("DescribeProductView").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeProductViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeProductViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for
     *        localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned
     *        product identifier. Customers must provide either Id or Name.
     * @return Result of the DescribeProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProvisionedProductResponse describeProvisionedProduct(
            DescribeProvisionedProductRequest describeProvisionedProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisionedProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisionedProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisionedProductRequest, DescribeProvisionedProductResponse>()
                            .withOperationName("DescribeProvisionedProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeProvisionedProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisionedProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     * @return Result of the DescribeProvisionedProductPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProvisionedProductPlanResponse describeProvisionedProductPlan(
            DescribeProvisionedProductPlanRequest describeProvisionedProductPlanRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisionedProductPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProvisionedProductPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisionedProductPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisionedProductPlanRequest, DescribeProvisionedProductPlanResponse>()
                            .withOperationName("DescribeProvisionedProductPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeProvisionedProductPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisionedProductPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     * @return Result of the DescribeProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProvisioningArtifactResponse describeProvisioningArtifact(
            DescribeProvisioningArtifactRequest describeProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningArtifactRequest, DescribeProvisioningArtifactResponse>()
                            .withOperationName("DescribeProvisioningArtifact").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     *
     * @param describeProvisioningParametersRequest
     * @return Result of the DescribeProvisioningParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeProvisioningParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProvisioningParametersResponse describeProvisioningParameters(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisioningParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisioningParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProvisioningParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResponse>()
                            .withOperationName("DescribeProvisioningParameters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeProvisioningParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisioningParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note>
     *
     * @param describeRecordRequest
     * @return Result of the DescribeRecord operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeRecordResponse describeRecord(DescribeRecordRequest describeRecordRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRecordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeRecordResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecord");

            return clientHandler.execute(new ClientExecutionParams<DescribeRecordRequest, DescribeRecordResponse>()
                    .withOperationName("DescribeRecord").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeRecordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRecordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     *
     * @param describeServiceActionRequest
     * @return Result of the DescribeServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServiceActionResponse describeServiceAction(DescribeServiceActionRequest describeServiceActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceAction");

            return clientHandler.execute(new ClientExecutionParams<DescribeServiceActionRequest, DescribeServiceActionResponse>()
                    .withOperationName("DescribeServiceAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeServiceActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     * @return Result of the DescribeServiceActionExecutionParameters operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServiceActionExecutionParametersResponse describeServiceActionExecutionParameters(
            DescribeServiceActionExecutionParametersRequest describeServiceActionExecutionParametersRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeServiceActionExecutionParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeServiceActionExecutionParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeServiceActionExecutionParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceActionExecutionParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceActionExecutionParametersRequest, DescribeServiceActionExecutionParametersResponse>()
                            .withOperationName("DescribeServiceActionExecutionParameters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeServiceActionExecutionParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeServiceActionExecutionParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     *
     * @param describeTagOptionRequest
     * @return Result of the DescribeTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DescribeTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTagOptionResponse describeTagOption(DescribeTagOptionRequest describeTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTagOptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTagOption");

            return clientHandler.execute(new ClientExecutionParams<DescribeTagOptionRequest, DescribeTagOptionResponse>()
                    .withOperationName("DescribeTagOption").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTagOptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTagOptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares,
     * but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with
     * your organization structure if the structure changes after calling this API. Only the management account in the
     * organization can call this API.
     * </p>
     * <p>
     * You cannot call this API if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations
     * access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the
     * organization structure. Specifically, accounts that you removed from the organization after disabling Service
     * Catalog access will retain access to the previously shared portfolio.
     * </p>
     * </important>
     *
     * @param disableAwsOrganizationsAccessRequest
     * @return Result of the DisableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableAwsOrganizationsAccessResponse disableAWSOrganizationsAccess(
            DisableAwsOrganizationsAccessRequest disableAwsOrganizationsAccessRequest) throws ResourceNotFoundException,
            InvalidStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableAwsOrganizationsAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisableAwsOrganizationsAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableAwsOrganizationsAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableAWSOrganizationsAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableAwsOrganizationsAccessRequest, DisableAwsOrganizationsAccessResponse>()
                            .withOperationName("DisableAWSOrganizationsAccess").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disableAwsOrganizationsAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisableAwsOrganizationsAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     * @return Result of the DisassociateBudgetFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateBudgetFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateBudgetFromResourceResponse disassociateBudgetFromResource(
            DisassociateBudgetFromResourceRequest disassociateBudgetFromResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateBudgetFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateBudgetFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateBudgetFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBudgetFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateBudgetFromResourceRequest, DisassociateBudgetFromResourceResponse>()
                            .withOperationName("DisassociateBudgetFromResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateBudgetFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateBudgetFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     * <p>
     * The <code>PrincipalType</code> and <code>PrincipalARN</code> must match the
     * <code>AssociatePrincipalWithPortfolio</code> call request details. For example, to disassociate an association
     * created with a <code>PrincipalARN</code> of <code>PrincipalType</code> IAM you must use the
     * <code>PrincipalType</code> IAM when calling <code>DisassociatePrincipalFromPortfolio</code>.
     * </p>
     * <p>
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share
     * recipient accounts will no longer be able to provision products in this portfolio using a role matching the name
     * of the associated principal.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * <note>
     * <p>
     * If you disassociate a principal from a portfolio, with PrincipalType as <code>IAM</code>, the same principal will
     * still have access to the portfolio if it matches one of the associated principals of type
     * <code>IAM_PATTERN</code>. To fully remove access for a principal, verify all the associated Principals of type
     * <code>IAM_PATTERN</code>, and then ensure you disassociate any <code>IAM_PATTERN</code> principals that match the
     * principal whose access you are removing.
     * </p>
     * </note>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     * @return Result of the DisassociatePrincipalFromPortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociatePrincipalFromPortfolioResponse disassociatePrincipalFromPortfolio(
            DisassociatePrincipalFromPortfolioRequest disassociatePrincipalFromPortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociatePrincipalFromPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociatePrincipalFromPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociatePrincipalFromPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePrincipalFromPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociatePrincipalFromPortfolioRequest, DisassociatePrincipalFromPortfolioResponse>()
                            .withOperationName("DisassociatePrincipalFromPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociatePrincipalFromPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociatePrincipalFromPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     * @return Result of the DisassociateProductFromPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         A resource that is currently in use. Ensure that the resource is not in use and retry the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateProductFromPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateProductFromPortfolioResponse disassociateProductFromPortfolio(
            DisassociateProductFromPortfolioRequest disassociateProductFromPortfolioRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateProductFromPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateProductFromPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateProductFromPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateProductFromPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateProductFromPortfolioRequest, DisassociateProductFromPortfolioResponse>()
                            .withOperationName("DisassociateProductFromPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateProductFromPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateProductFromPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     * @return Result of the DisassociateServiceActionFromProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateServiceActionFromProvisioningArtifactResponse disassociateServiceActionFromProvisioningArtifact(
            DisassociateServiceActionFromProvisioningArtifactRequest disassociateServiceActionFromProvisioningArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateServiceActionFromProvisioningArtifactResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateServiceActionFromProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateServiceActionFromProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateServiceActionFromProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateServiceActionFromProvisioningArtifactRequest, DisassociateServiceActionFromProvisioningArtifactResponse>()
                            .withOperationName("DisassociateServiceActionFromProvisioningArtifact")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateServiceActionFromProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DisassociateServiceActionFromProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     * @return Result of the DisassociateTagOptionFromResource operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.DisassociateTagOptionFromResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateTagOptionFromResourceResponse disassociateTagOptionFromResource(
            DisassociateTagOptionFromResourceRequest disassociateTagOptionFromResourceRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateTagOptionFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateTagOptionFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateTagOptionFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTagOptionFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateTagOptionFromResourceRequest, DisassociateTagOptionFromResourceResponse>()
                            .withOperationName("DisassociateTagOptionFromResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateTagOptionFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateTagOptionFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on
     * your organization in order to sync your shares with the current structure. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * When you call this API, Service Catalog calls <code>organizations:EnableAWSServiceAccess</code> on your behalf so
     * that your shares stay in sync with any changes in your Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     * <important>
     * <p>
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the
     * portfolio access permissions might not sync with the latest changes to the organization structure. Specifically,
     * accounts that you removed from the organization after disabling Service Catalog access, and before you enabled
     * access again, can retain access to the previously shared portfolio. As a result, an account that has been removed
     * from the organization might still be able to create or manage Amazon Web Services resources when it is no longer
     * authorized to do so. Amazon Web Services is working to resolve this issue.
     * </p>
     * </important>
     *
     * @param enableAwsOrganizationsAccessRequest
     * @return Result of the EnableAWSOrganizationsAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.EnableAWSOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EnableAwsOrganizationsAccessResponse enableAWSOrganizationsAccess(
            EnableAwsOrganizationsAccessRequest enableAwsOrganizationsAccessRequest) throws ResourceNotFoundException,
            InvalidStateException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableAwsOrganizationsAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EnableAwsOrganizationsAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableAwsOrganizationsAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableAWSOrganizationsAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableAwsOrganizationsAccessRequest, EnableAwsOrganizationsAccessResponse>()
                            .withOperationName("EnableAWSOrganizationsAccess").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(enableAwsOrganizationsAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableAwsOrganizationsAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     * @return Result of the ExecuteProvisionedProductPlan operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteProvisionedProductPlanResponse executeProvisionedProductPlan(
            ExecuteProvisionedProductPlanRequest executeProvisionedProductPlanRequest) throws InvalidParametersException,
            ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteProvisionedProductPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeProvisionedProductPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteProvisionedProductPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteProvisionedProductPlanRequest, ExecuteProvisionedProductPlanResponse>()
                            .withOperationName("ExecuteProvisionedProductPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(executeProvisionedProductPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteProvisionedProductPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     * @return Result of the ExecuteProvisionedProductServiceAction operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteProvisionedProductServiceActionResponse executeProvisionedProductServiceAction(
            ExecuteProvisionedProductServiceActionRequest executeProvisionedProductServiceActionRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteProvisionedProductServiceActionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ExecuteProvisionedProductServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeProvisionedProductServiceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteProvisionedProductServiceAction");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteProvisionedProductServiceActionRequest, ExecuteProvisionedProductServiceActionResponse>()
                            .withOperationName("ExecuteProvisionedProductServiceAction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(executeProvisionedProductServiceActionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteProvisionedProductServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     * @return Result of the GetAWSOrganizationsAccessStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetAWSOrganizationsAccessStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAwsOrganizationsAccessStatusResponse getAWSOrganizationsAccessStatus(
            GetAwsOrganizationsAccessStatusRequest getAwsOrganizationsAccessStatusRequest) throws ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAwsOrganizationsAccessStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAwsOrganizationsAccessStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAwsOrganizationsAccessStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAWSOrganizationsAccessStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAwsOrganizationsAccessStatusRequest, GetAwsOrganizationsAccessStatusResponse>()
                            .withOperationName("GetAWSOrganizationsAccessStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getAwsOrganizationsAccessStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAwsOrganizationsAccessStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return Result of the GetProvisionedProductOutputs operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProvisionedProductOutputsResponse getProvisionedProductOutputs(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProvisionedProductOutputsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetProvisionedProductOutputsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProvisionedProductOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProvisionedProductOutputs");

            return clientHandler
                    .execute(new ClientExecutionParams<GetProvisionedProductOutputsRequest, GetProvisionedProductOutputsResponse>()
                            .withOperationName("GetProvisionedProductOutputs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getProvisionedProductOutputsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetProvisionedProductOutputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client
     *             .getProvisionedProductOutputsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsIterable responses = client.getProvisionedProductOutputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.GetProvisionedProductOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProvisionedProductOutputsIterable getProvisionedProductOutputsPaginator(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new GetProvisionedProductOutputsIterable(this, applyPaginatorUserAgent(getProvisionedProductOutputsRequest));
    }

    /**
     * <p>
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service
     * Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the
     * provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks are
     * not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, and
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <note>
     * <p>
     * When you import an existing CloudFormation stack into a portfolio, constraints that are associated with the
     * product aren't applied during the import process. The constraints are applied after you call
     * <code>UpdateProvisionedProduct</code> for the provisioned product.
     * </p>
     * </note>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     *
     * @param importAsProvisionedProductRequest
     * @return Result of the ImportAsProvisionedProduct operation returned by the service.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ImportAsProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportAsProvisionedProductResponse importAsProvisionedProduct(
            ImportAsProvisionedProductRequest importAsProvisionedProductRequest) throws DuplicateResourceException,
            InvalidStateException, ResourceNotFoundException, InvalidParametersException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportAsProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportAsProvisionedProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importAsProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportAsProvisionedProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportAsProvisionedProductRequest, ImportAsProvisionedProductResponse>()
                            .withOperationName("ImportAsProvisionedProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(importAsProvisionedProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportAsProvisionedProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return Result of the ListAcceptedPortfolioShares operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAcceptedPortfolioSharesResponse listAcceptedPortfolioShares(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAcceptedPortfolioSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAcceptedPortfolioSharesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAcceptedPortfolioSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAcceptedPortfolioShares");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAcceptedPortfolioSharesRequest, ListAcceptedPortfolioSharesResponse>()
                            .withOperationName("ListAcceptedPortfolioShares").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAcceptedPortfolioSharesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAcceptedPortfolioSharesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying
     * the <code>PortfolioShareType</code>, you can list portfolios for which organizational shares were accepted by
     * this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client
     *             .listAcceptedPortfolioSharesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesIterable responses = client.listAcceptedPortfolioSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListAcceptedPortfolioShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAcceptedPortfolioSharesIterable listAcceptedPortfolioSharesPaginator(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) throws InvalidParametersException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListAcceptedPortfolioSharesIterable(this, applyPaginatorUserAgent(listAcceptedPortfolioSharesRequest));
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return Result of the ListBudgetsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBudgetsForResourceResponse listBudgetsForResource(ListBudgetsForResourceRequest listBudgetsForResourceRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBudgetsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBudgetsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBudgetsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBudgetsForResource");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBudgetsForResourceRequest, ListBudgetsForResourceResponse>()
                            .withOperationName("ListBudgetsForResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listBudgetsForResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBudgetsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client
     *             .listBudgetsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourceIterable responses = client.listBudgetsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListBudgetsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBudgetsForResourceIterable listBudgetsForResourcePaginator(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListBudgetsForResourceIterable(this, applyPaginatorUserAgent(listBudgetsForResourceRequest));
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return Result of the ListConstraintsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConstraintsForPortfolioResponse listConstraintsForPortfolio(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConstraintsForPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConstraintsForPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConstraintsForPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConstraintsForPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConstraintsForPortfolioRequest, ListConstraintsForPortfolioResponse>()
                            .withOperationName("ListConstraintsForPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listConstraintsForPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConstraintsForPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client
     *             .listConstraintsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioIterable responses = client.listConstraintsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListConstraintsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConstraintsForPortfolioIterable listConstraintsForPortfolioPaginator(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListConstraintsForPortfolioIterable(this, applyPaginatorUserAgent(listConstraintsForPortfolioRequest));
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param listLaunchPathsRequest
     * @return Result of the ListLaunchPaths operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLaunchPathsResponse listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLaunchPathsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLaunchPathsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchPathsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchPaths");

            return clientHandler.execute(new ClientExecutionParams<ListLaunchPathsRequest, ListLaunchPathsResponse>()
                    .withOperationName("ListLaunchPaths").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLaunchPathsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLaunchPathsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is
     * necessary when provisioning a product. A path also determines the constraints that are put on a product. A path
     * is dependent on a specific product, porfolio, and principal.
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client
     *             .listLaunchPathsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsIterable responses = client.listLaunchPathsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchPathsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListLaunchPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLaunchPathsIterable listLaunchPathsPaginator(ListLaunchPathsRequest listLaunchPathsRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListLaunchPathsIterable(this, applyPaginatorUserAgent(listLaunchPathsRequest));
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return Result of the ListOrganizationPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOrganizationPortfolioAccessResponse listOrganizationPortfolioAccess(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOrganizationPortfolioAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOrganizationPortfolioAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOrganizationPortfolioAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizationPortfolioAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationPortfolioAccessRequest, ListOrganizationPortfolioAccessResponse>()
                            .withOperationName("ListOrganizationPortfolioAccess").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listOrganizationPortfolioAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOrganizationPortfolioAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client
     *             .listOrganizationPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessIterable responses = client.listOrganizationPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListOrganizationPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOrganizationPortfolioAccessIterable listOrganizationPortfolioAccessPaginator(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) throws ResourceNotFoundException,
            InvalidParametersException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListOrganizationPortfolioAccessIterable(this, applyPaginatorUserAgent(listOrganizationPortfolioAccessRequest));
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return Result of the ListPortfolioAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPortfolioAccessResponse listPortfolioAccess(ListPortfolioAccessRequest listPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortfolioAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPortfolioAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfolioAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfolioAccess");

            return clientHandler.execute(new ClientExecutionParams<ListPortfolioAccessRequest, ListPortfolioAccessResponse>()
                    .withOperationName("ListPortfolioAccess").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPortfolioAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPortfolioAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client
     *             .listPortfolioAccessPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessIterable responses = client.listPortfolioAccessPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolioAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPortfolioAccessIterable listPortfolioAccessPaginator(ListPortfolioAccessRequest listPortfolioAccessRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListPortfolioAccessIterable(this, applyPaginatorUserAgent(listPortfolioAccessRequest));
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @param listPortfoliosRequest
     * @return Result of the ListPortfolios operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPortfoliosResponse listPortfolios(ListPortfoliosRequest listPortfoliosRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortfoliosResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPortfoliosResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfoliosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfolios");

            return clientHandler.execute(new ClientExecutionParams<ListPortfoliosRequest, ListPortfoliosResponse>()
                    .withOperationName("ListPortfolios").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPortfoliosRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPortfoliosRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client
     *             .listPortfoliosPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosIterable responses = client.listPortfoliosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfolios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPortfoliosIterable listPortfoliosPaginator(ListPortfoliosRequest listPortfoliosRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPortfoliosIterable(this, applyPaginatorUserAgent(listPortfoliosRequest));
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return Result of the ListPortfoliosForProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPortfoliosForProductResponse listPortfoliosForProduct(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortfoliosForProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPortfoliosForProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfoliosForProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfoliosForProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPortfoliosForProductRequest, ListPortfoliosForProductResponse>()
                            .withOperationName("ListPortfoliosForProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPortfoliosForProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPortfoliosForProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client
     *             .listPortfoliosForProductPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductIterable responses = client.listPortfoliosForProductPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPortfoliosForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPortfoliosForProductIterable listPortfoliosForProductPaginator(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPortfoliosForProductIterable(this, applyPaginatorUserAgent(listPortfoliosForProductRequest));
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return Result of the ListPrincipalsForPortfolio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPrincipalsForPortfolioResponse listPrincipalsForPortfolio(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPrincipalsForPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPrincipalsForPortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPrincipalsForPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPrincipalsForPortfolio");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPrincipalsForPortfolioRequest, ListPrincipalsForPortfolioResponse>()
                            .withOperationName("ListPrincipalsForPortfolio").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPrincipalsForPortfolioRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPrincipalsForPortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all <code>PrincipalARN</code>s and corresponding <code>PrincipalType</code>s associated with the specified
     * portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client
     *             .listPrincipalsForPortfolioPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioIterable responses = client.listPrincipalsForPortfolioPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListPrincipalsForPortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPrincipalsForPortfolioIterable listPrincipalsForPortfolioPaginator(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListPrincipalsForPortfolioIterable(this, applyPaginatorUserAgent(listPrincipalsForPortfolioRequest));
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     * @return Result of the ListProvisionedProductPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisionedProductPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisionedProductPlansResponse listProvisionedProductPlans(
            ListProvisionedProductPlansRequest listProvisionedProductPlansRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisionedProductPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisionedProductPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisionedProductPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisionedProductPlans");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisionedProductPlansRequest, ListProvisionedProductPlansResponse>()
                            .withOperationName("ListProvisionedProductPlans").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listProvisionedProductPlansRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisionedProductPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     * @return Result of the ListProvisioningArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisioningArtifactsResponse listProvisioningArtifacts(
            ListProvisioningArtifactsRequest listProvisioningArtifactsRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisioningArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisioningArtifactsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisioningArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningArtifacts");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningArtifactsRequest, ListProvisioningArtifactsResponse>()
                            .withOperationName("ListProvisioningArtifacts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listProvisioningArtifactsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisioningArtifactsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return Result of the ListProvisioningArtifactsForServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisioningArtifactsForServiceActionResponse listProvisioningArtifactsForServiceAction(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisioningArtifactsForServiceActionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListProvisioningArtifactsForServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProvisioningArtifactsForServiceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningArtifactsForServiceAction");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningArtifactsForServiceActionRequest, ListProvisioningArtifactsForServiceActionResponse>()
                            .withOperationName("ListProvisioningArtifactsForServiceAction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listProvisioningArtifactsForServiceActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisioningArtifactsForServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client
     *             .listProvisioningArtifactsForServiceActionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionIterable responses = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisioningArtifactsForServiceActionIterable listProvisioningArtifactsForServiceActionPaginator(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListProvisioningArtifactsForServiceActionIterable(this,
                applyPaginatorUserAgent(listProvisioningArtifactsForServiceActionRequest));
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @param listRecordHistoryRequest
     * @return Result of the ListRecordHistory operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListRecordHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecordHistoryResponse listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecordHistoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRecordHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecordHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecordHistory");

            return clientHandler.execute(new ClientExecutionParams<ListRecordHistoryRequest, ListRecordHistoryResponse>()
                    .withOperationName("ListRecordHistory").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRecordHistoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRecordHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return Result of the ListResourcesForTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourcesForTagOptionResponse listResourcesForTagOption(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourcesForTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourcesForTagOptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourcesForTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourcesForTagOption");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourcesForTagOptionRequest, ListResourcesForTagOptionResponse>()
                            .withOperationName("ListResourcesForTagOption").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listResourcesForTagOptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourcesForTagOptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client
     *             .listResourcesForTagOptionPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionIterable responses = client.listResourcesForTagOptionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListResourcesForTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourcesForTagOptionIterable listResourcesForTagOptionPaginator(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) throws TagOptionNotMigratedException,
            ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListResourcesForTagOptionIterable(this, applyPaginatorUserAgent(listResourcesForTagOptionRequest));
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @param listServiceActionsRequest
     * @return Result of the ListServiceActions operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceActionsResponse listServiceActions(ListServiceActionsRequest listServiceActionsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListServiceActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListServiceActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServiceActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceActions");

            return clientHandler.execute(new ClientExecutionParams<ListServiceActionsRequest, ListServiceActionsResponse>()
                    .withOperationName("ListServiceActions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listServiceActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListServiceActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client
     *             .listServiceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsIterable responses = client.listServiceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceActionsIterable listServiceActionsPaginator(ListServiceActionsRequest listServiceActionsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new ListServiceActionsIterable(this, applyPaginatorUserAgent(listServiceActionsRequest));
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return Result of the ListServiceActionsForProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceActionsForProvisioningArtifactResponse listServiceActionsForProvisioningArtifact(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListServiceActionsForProvisioningArtifactResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListServiceActionsForProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listServiceActionsForProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceActionsForProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<ListServiceActionsForProvisioningArtifactRequest, ListServiceActionsForProvisioningArtifactResponse>()
                            .withOperationName("ListServiceActionsForProvisioningArtifact").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listServiceActionsForProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListServiceActionsForProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client
     *             .listServiceActionsForProvisioningArtifactPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactIterable responses = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceActionsForProvisioningArtifactIterable listServiceActionsForProvisioningArtifactPaginator(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListServiceActionsForProvisioningArtifactIterable(this,
                applyPaginatorUserAgent(listServiceActionsForProvisioningArtifactRequest));
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific Amazon Web Services account name or Region.
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     * @return Result of the ListStackInstancesForProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackInstancesForProvisionedProductResponse listStackInstancesForProvisionedProduct(
            ListStackInstancesForProvisionedProductRequest listStackInstancesForProvisionedProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStackInstancesForProvisionedProductResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListStackInstancesForProvisionedProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listStackInstancesForProvisionedProductRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackInstancesForProvisionedProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackInstancesForProvisionedProductRequest, ListStackInstancesForProvisionedProductResponse>()
                            .withOperationName("ListStackInstancesForProvisionedProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listStackInstancesForProvisionedProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackInstancesForProvisionedProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @param listTagOptionsRequest
     * @return Result of the ListTagOptions operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagOptionsResponse listTagOptions(ListTagOptionsRequest listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagOptions");

            return clientHandler.execute(new ClientExecutionParams<ListTagOptionsRequest, ListTagOptionsResponse>()
                    .withOperationName("ListTagOptions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client
     *             .listTagOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsIterable responses = client.listTagOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ListTagOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagOptionsIterable listTagOptionsPaginator(ListTagOptionsRequest listTagOptionsRequest)
            throws TagOptionNotMigratedException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new ListTagOptionsIterable(this, applyPaginatorUserAgent(listTagOptionsRequest));
    }

    /**
     * <p>
     * Notifies the result of the provisioning engine execution.
     * </p>
     *
     * @param notifyProvisionProductEngineWorkflowResultRequest
     * @return Result of the NotifyProvisionProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyProvisionProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyProvisionProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public NotifyProvisionProductEngineWorkflowResultResponse notifyProvisionProductEngineWorkflowResult(
            NotifyProvisionProductEngineWorkflowResultRequest notifyProvisionProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<NotifyProvisionProductEngineWorkflowResultResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, NotifyProvisionProductEngineWorkflowResultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                notifyProvisionProductEngineWorkflowResultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "NotifyProvisionProductEngineWorkflowResult");

            return clientHandler
                    .execute(new ClientExecutionParams<NotifyProvisionProductEngineWorkflowResultRequest, NotifyProvisionProductEngineWorkflowResultResponse>()
                            .withOperationName("NotifyProvisionProductEngineWorkflowResult").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(notifyProvisionProductEngineWorkflowResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new NotifyProvisionProductEngineWorkflowResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Notifies the result of the terminate engine execution.
     * </p>
     *
     * @param notifyTerminateProvisionedProductEngineWorkflowResultRequest
     * @return Result of the NotifyTerminateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyTerminateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyTerminateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public NotifyTerminateProvisionedProductEngineWorkflowResultResponse notifyTerminateProvisionedProductEngineWorkflowResult(
            NotifyTerminateProvisionedProductEngineWorkflowResultRequest notifyTerminateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<NotifyTerminateProvisionedProductEngineWorkflowResultResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, NotifyTerminateProvisionedProductEngineWorkflowResultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                notifyTerminateProvisionedProductEngineWorkflowResultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "NotifyTerminateProvisionedProductEngineWorkflowResult");

            return clientHandler
                    .execute(new ClientExecutionParams<NotifyTerminateProvisionedProductEngineWorkflowResultRequest, NotifyTerminateProvisionedProductEngineWorkflowResultResponse>()
                            .withOperationName("NotifyTerminateProvisionedProductEngineWorkflowResult")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(notifyTerminateProvisionedProductEngineWorkflowResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new NotifyTerminateProvisionedProductEngineWorkflowResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Notifies the result of the update engine execution.
     * </p>
     *
     * @param notifyUpdateProvisionedProductEngineWorkflowResultRequest
     * @return Result of the NotifyUpdateProvisionedProductEngineWorkflowResult operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.NotifyUpdateProvisionedProductEngineWorkflowResult
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/NotifyUpdateProvisionedProductEngineWorkflowResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public NotifyUpdateProvisionedProductEngineWorkflowResultResponse notifyUpdateProvisionedProductEngineWorkflowResult(
            NotifyUpdateProvisionedProductEngineWorkflowResultRequest notifyUpdateProvisionedProductEngineWorkflowResultRequest)
            throws InvalidParametersException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<NotifyUpdateProvisionedProductEngineWorkflowResultResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, NotifyUpdateProvisionedProductEngineWorkflowResultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                notifyUpdateProvisionedProductEngineWorkflowResultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "NotifyUpdateProvisionedProductEngineWorkflowResult");

            return clientHandler
                    .execute(new ClientExecutionParams<NotifyUpdateProvisionedProductEngineWorkflowResultRequest, NotifyUpdateProvisionedProductEngineWorkflowResultResponse>()
                            .withOperationName("NotifyUpdateProvisionedProductEngineWorkflowResult")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(notifyUpdateProvisionedProductEngineWorkflowResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new NotifyUpdateProvisionedProductEngineWorkflowResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on
     * an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the
     * status of this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't
     * include conflicted keys as tags, or this will cause the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     * <note>
     * <p>
     * When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to
     * the portfolio. For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html">Granting users
     * access</a> in the <i>Service Catalog User Guide</i>.
     * </p>
     * </note>
     *
     * @param provisionProductRequest
     * @return Result of the ProvisionProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ProvisionProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ProvisionProductResponse provisionProduct(ProvisionProductRequest provisionProductRequest)
            throws InvalidParametersException, ResourceNotFoundException, DuplicateResourceException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ProvisionProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ProvisionProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionProduct");

            return clientHandler.execute(new ClientExecutionParams<ProvisionProductRequest, ProvisionProductResponse>()
                    .withOperationName("ProvisionProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(provisionProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ProvisionProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     *
     * @param rejectPortfolioShareRequest
     * @return Result of the RejectPortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.RejectPortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RejectPortfolioShareResponse rejectPortfolioShare(RejectPortfolioShareRequest rejectPortfolioShareRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectPortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectPortfolioShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectPortfolioShare");

            return clientHandler.execute(new ClientExecutionParams<RejectPortfolioShareRequest, RejectPortfolioShareResponse>()
                    .withOperationName("RejectPortfolioShare").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rejectPortfolioShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RejectPortfolioShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @param scanProvisionedProductsRequest
     * @return Result of the ScanProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.ScanProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ScanProvisionedProductsResponse scanProvisionedProducts(ScanProvisionedProductsRequest scanProvisionedProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ScanProvisionedProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ScanProvisionedProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, scanProvisionedProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ScanProvisionedProducts");

            return clientHandler
                    .execute(new ClientExecutionParams<ScanProvisionedProductsRequest, ScanProvisionedProductsResponse>()
                            .withOperationName("ScanProvisionedProducts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(scanProvisionedProductsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ScanProvisionedProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @param searchProductsRequest
     * @return Result of the SearchProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchProductsResponse searchProducts(SearchProductsRequest searchProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchProductsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProducts");

            return clientHandler.execute(new ClientExecutionParams<SearchProductsRequest, SearchProductsResponse>()
                    .withOperationName("SearchProducts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchProductsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client
     *             .searchProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsIterable responses = client.searchProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchProductsIterable searchProductsPaginator(SearchProductsRequest searchProductsRequest)
            throws InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        return new SearchProductsIterable(this, applyPaginatorUserAgent(searchProductsRequest));
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return Result of the SearchProductsAsAdmin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProductsAsAdminResponse searchProductsAsAdmin(SearchProductsAsAdminRequest searchProductsAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchProductsAsAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchProductsAsAdminResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProductsAsAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProductsAsAdmin");

            return clientHandler.execute(new ClientExecutionParams<SearchProductsAsAdminRequest, SearchProductsAsAdminResponse>()
                    .withOperationName("SearchProductsAsAdmin").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchProductsAsAdminRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchProductsAsAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client
     *             .searchProductsAsAdminPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminIterable responses = client.searchProductsAsAdminPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProductsAsAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProductsAsAdminIterable searchProductsAsAdminPaginator(SearchProductsAsAdminRequest searchProductsAsAdminRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        return new SearchProductsAsAdminIterable(this, applyPaginatorUserAgent(searchProductsAsAdminRequest));
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return Result of the SearchProvisionedProducts operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProvisionedProductsResponse searchProvisionedProducts(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchProvisionedProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchProvisionedProductsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProvisionedProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProvisionedProducts");

            return clientHandler
                    .execute(new ClientExecutionParams<SearchProvisionedProductsRequest, SearchProvisionedProductsResponse>()
                            .withOperationName("SearchProvisionedProducts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(searchProvisionedProductsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SearchProvisionedProductsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client
     *             .searchProvisionedProductsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsIterable responses = client.searchProvisionedProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.SearchProvisionedProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProvisionedProductsIterable searchProvisionedProductsPaginator(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) throws InvalidParametersException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        return new SearchProvisionedProductsIterable(this, applyPaginatorUserAgent(searchProvisionedProductsRequest));
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param terminateProvisionedProductRequest
     * @return Result of the TerminateProvisionedProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.TerminateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateProvisionedProductResponse terminateProvisionedProduct(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateProvisionedProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateProvisionedProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<TerminateProvisionedProductRequest, TerminateProvisionedProductResponse>()
                            .withOperationName("TerminateProvisionedProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(terminateProvisionedProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new TerminateProvisionedProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     *
     * @param updateConstraintRequest
     * @return Result of the UpdateConstraint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateConstraint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConstraintResponse updateConstraint(UpdateConstraintRequest updateConstraintRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConstraintResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateConstraintResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConstraint");

            return clientHandler.execute(new ClientExecutionParams<UpdateConstraintRequest, UpdateConstraintResponse>()
                    .withOperationName("UpdateConstraint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateConstraintRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateConstraintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     *
     * @param updatePortfolioRequest
     * @return Result of the UpdatePortfolio operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The current limits of the service would have been exceeded by this operation. Decrease your resource use
     *         or increase your service limits and retry the operation.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePortfolioResponse updatePortfolio(UpdatePortfolioRequest updatePortfolioRequest)
            throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, TagOptionNotMigratedException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePortfolioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortfolio");

            return clientHandler.execute(new ClientExecutionParams<UpdatePortfolioRequest, UpdatePortfolioResponse>()
                    .withOperationName("UpdatePortfolio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePortfolioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePortfolioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable <code>TagOptions</code> sharing
     * or Principal sharing for an existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code>CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be COMPLETED.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     * <note>
     * <p>
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that
     * portfolio is then shared with other accounts. For a user in a recipient account who is <i>not</i> an Service
     * Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role
     * that matches a principal name association for the portfolio. Although this user may not know which principal
     * names are associated through Service Catalog, they may be able to guess the user. If this potential escalation
     * path is a concern, then Service Catalog recommends using <code>PrincipalType</code> as <code>IAM</code>. With
     * this configuration, the <code>PrincipalARN</code> must already exist in the recipient account before it can be
     * associated.
     * </p>
     * </note>
     *
     * @param updatePortfolioShareRequest
     * @return Result of the UpdatePortfolioShare operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws OperationNotSupportedException
     *         The operation is not supported.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdatePortfolioShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePortfolioShareResponse updatePortfolioShare(UpdatePortfolioShareRequest updatePortfolioShareRequest)
            throws ResourceNotFoundException, InvalidParametersException, OperationNotSupportedException, InvalidStateException,
            AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePortfolioShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortfolioShare");

            return clientHandler.execute(new ClientExecutionParams<UpdatePortfolioShareRequest, UpdatePortfolioShareResponse>()
                    .withOperationName("UpdatePortfolioShare").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePortfolioShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePortfolioShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     *
     * @param updateProductRequest
     * @return Result of the UpdateProduct operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateProductResponse updateProduct(UpdateProductRequest updateProductRequest) throws ResourceNotFoundException,
            InvalidParametersException, TagOptionNotMigratedException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProduct");

            return clientHandler.execute(new ClientExecutionParams<UpdateProductRequest, UpdateProductResponse>()
                    .withOperationName("UpdateProduct").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateProductRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param updateProvisionedProductRequest
     * @return Result of the UpdateProvisionedProduct operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateProvisionedProductResponse updateProvisionedProduct(
            UpdateProvisionedProductRequest updateProvisionedProductRequest) throws InvalidParametersException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateProvisionedProductResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisionedProduct");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisionedProductRequest, UpdateProvisionedProductResponse>()
                            .withOperationName("UpdateProvisionedProduct").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateProvisionedProductRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateProvisionedProductRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     * @return Result of the UpdateProvisionedProductProperties operation returned by the service.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidStateException
     *         An attempt was made to modify a resource that is in a state that is not valid. Check your resources to
     *         ensure that they are in valid states before retrying the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateProvisionedProductPropertiesResponse updateProvisionedProductProperties(
            UpdateProvisionedProductPropertiesRequest updateProvisionedProductPropertiesRequest)
            throws InvalidParametersException, ResourceNotFoundException, InvalidStateException, AwsServiceException,
            SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProvisionedProductPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateProvisionedProductPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateProvisionedProductPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisionedProductProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisionedProductPropertiesRequest, UpdateProvisionedProductPropertiesResponse>()
                            .withOperationName("UpdateProvisionedProductProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateProvisionedProductPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateProvisionedProductPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     * @return Result of the UpdateProvisioningArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateProvisioningArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateProvisioningArtifactResponse updateProvisioningArtifact(
            UpdateProvisioningArtifactRequest updateProvisioningArtifactRequest) throws ResourceNotFoundException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateProvisioningArtifactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisioningArtifact");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisioningArtifactRequest, UpdateProvisioningArtifactResponse>()
                            .withOperationName("UpdateProvisioningArtifact").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateProvisioningArtifactRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateProvisioningArtifactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     *
     * @param updateServiceActionRequest
     * @return Result of the UpdateServiceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateServiceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateServiceActionResponse updateServiceAction(UpdateServiceActionRequest updateServiceActionRequest)
            throws ResourceNotFoundException, InvalidParametersException, AwsServiceException, SdkClientException,
            ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateServiceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceAction");

            return clientHandler.execute(new ClientExecutionParams<UpdateServiceActionRequest, UpdateServiceActionResponse>()
                    .withOperationName("UpdateServiceAction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateServiceActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateServiceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     *
     * @param updateTagOptionRequest
     * @return Result of the UpdateTagOption operation returned by the service.
     * @throws TagOptionNotMigratedException
     *         An operation requiring TagOptions failed because the TagOptions migration process has not been performed
     *         for this account. Use the Amazon Web Services Management Console to perform the migration process before
     *         retrying the operation.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws DuplicateResourceException
     *         The specified resource is a duplicate.
     * @throws InvalidParametersException
     *         One or more parameters provided to the operation are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogClient.UpdateTagOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTagOptionResponse updateTagOption(UpdateTagOptionRequest updateTagOptionRequest)
            throws TagOptionNotMigratedException, ResourceNotFoundException, DuplicateResourceException,
            InvalidParametersException, AwsServiceException, SdkClientException, ServiceCatalogException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTagOptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTagOption");

            return clientHandler.execute(new ClientExecutionParams<UpdateTagOptionRequest, UpdateTagOptionResponse>()
                    .withOperationName("UpdateTagOption").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateTagOptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTagOptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private <T extends ServiceCatalogRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ServiceCatalogException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParametersException")
                                .exceptionBuilderSupplier(InvalidParametersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                                .exceptionBuilderSupplier(OperationNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateException")
                                .exceptionBuilderSupplier(InvalidStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateResourceException")
                                .exceptionBuilderSupplier(DuplicateResourceException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagOptionNotMigratedException")
                                .exceptionBuilderSupplier(TagOptionNotMigratedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ServiceCatalogServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
